/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.hazelcast.jet.config.ResourceType;
import com.hazelcast.webmonitor.controller.dto.UserCodeNamespacesDTO;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.MetricDataPointProcessor;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.model.UserCodeNamespacesModel;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.DisconnectedFromClusterEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserCodeNamespacesStatsRegistry
implements MetricDataPointProcessor {
    private static final int REGISTRY_MAX_SIZE = 100000;
    private static final int REGISTRY_TTL_MIN = 5;
    private final Clock clock;
    private final ConcurrentMap<String, Cache<String, UserCodeNamespacesModel>> namespaces = new ConcurrentHashMap();

    @EventListener
    public void cleanUpDisconnectedCluster(DisconnectedFromClusterEvent event) {
        String cluster = event.getCluster();
        this.namespaces.remove(cluster);
    }

    public boolean shouldProcessDataPoint(MetricDataPoint dataPoint) {
        String dataPointName = dataPoint.getName();
        return dataPointName.startsWith("ucn");
    }

    public void processDataPoint(MetricDataPoint dataPoint, MemberIdentifier memberIdent) {
        Map tags = dataPoint.getTags();
        String name = (String)tags.get(Tag.NAME.getName());
        if (name == null) {
            return;
        }
        String dataPointName = dataPoint.getName();
        String cluster = memberIdent.getClusterName();
        Cache cache = this.namespaces.computeIfAbsent(cluster, key -> this.createEntityCache());
        cache.asMap().compute(name, (k, v) -> {
            UserCodeNamespacesModel record = v;
            if (record == null) {
                record = UserCodeNamespacesModel.builder().name(name).sizes(new HashMap()).types(EnumSet.noneOf(ResourceType.class)).build();
            }
            if (dataPointName.contains("resourceCount")) {
                record.setCount(dataPoint.getValue());
            }
            if (dataPointName.contains("resourceSizeBytes")) {
                String resourceId = (String)tags.get("resourceId");
                record.getSizes().put(resourceId, dataPoint.getValue());
            }
            if (dataPointName.contains("resourceType")) {
                record.getTypes().add(ResourceType.getById((int)Math.toIntExact(dataPoint.getValue())));
            }
            if (dataPointName.contains("updateTime")) {
                record.setUpdateTime(dataPoint.getValue());
            }
            return record;
        });
    }

    public List<UserCodeNamespacesDTO> getNamespaces(String cluster) {
        Cache clusterNamespaces = (Cache)this.namespaces.get(cluster);
        if (clusterNamespaces == null) {
            return new ArrayList<UserCodeNamespacesDTO>();
        }
        return clusterNamespaces.asMap().values().stream().map(record -> UserCodeNamespacesDTO.builder().updateTime(record.getUpdateTime()).name(record.getName()).count(record.getCount()).size(record.getTotalSize()).type(record.getType()).build()).toList();
    }

    private <T> Cache<String, T> createEntityCache() {
        return Caffeine.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).maximumSize(100000L).ticker(() -> ((Clock)this.clock).nanoTime()).build();
    }

    @ConstructorProperties(value={"clock"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UserCodeNamespacesStatsRegistry(Clock clock) {
        this.clock = clock;
    }
}

