/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.controller.dto.MigrationStateDTO;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusterStatsService;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class MigrationStatusNotifier {
    private final ClusterManager clusterManager;
    private final ClusterStatsService clusterStatsService;
    private final Notifier notifier;

    public MigrationStatusNotifier(ClusterManager clusterManager, ClusterStatsService clusterStatsService, Notifier notifier) {
        this.clusterManager = clusterManager;
        this.clusterStatsService = clusterStatsService;
        this.notifier = notifier;
    }

    @EventListener
    public void checkMigrationStatus(BrowserHeartBeatEvent event) {
        MigrationStateDTO migrationState;
        long migrationQueueSize;
        String cluster = event.getCluster();
        boolean connected = this.clusterManager.isClusterConnected(cluster);
        if (connected && (migrationQueueSize = (migrationState = this.clusterStatsService.getClusterMigrationState(cluster)).getMigrationQueueSize()) > 0L) {
            String message = "data is currently being repartitioned. (" + migrationQueueSize + " waiting migrations)";
            this.notifier.signal(Note.Matter.REPARTITION_IS_IN_PROGRESS.on(cluster, message));
        }
    }
}

