/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.webmonitor.metrics.utils.TimeUtil;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.TimedMemberState;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.StateManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class MembersTimeDiffNotifier {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MembersTimeDiffNotifier.class);
    private final StateManager stateManager;
    private final Notifier notifier;
    private final Clock clock;
    private static final int MAX_NUMBER_OF_DISPLAYED_MEMBERS = 10;

    public MembersTimeDiffNotifier(StateManager stateManager, Notifier notifier, Clock clock) {
        this.stateManager = stateManager;
        this.notifier = notifier;
        this.clock = clock;
    }

    @EventListener
    public void runMembersTimeDiffChecker(BrowserHeartBeatEvent event) {
        String cluster = event.getCluster();
        TreeSet<String> timeDriftingMembers = new TreeSet<String>();
        long currentTime = this.clock.currentTimeMillis();
        AllState state = this.stateManager.getLatestState(cluster);
        if (state != null) {
            for (Map.Entry stateEntry : state.getTimedMemberStates().entries()) {
                long millisecondDiff;
                TimedMemberState timedMemberState = (TimedMemberState)stateEntry.getValue();
                String address = ((TimedMemberState)stateEntry.getValue()).getMemberState().getAddress();
                long memberTime = timedMemberState.getTime();
                if (memberTime <= 0L || (millisecondDiff = Math.abs(currentTime - memberTime)) <= TimeUtil.ONE_MINUTE_IN_MS) continue;
                log.debug("The time difference for member " + address + " is greater than one minute: memberTime= " + memberTime + " and currentTime= " + currentTime);
                timeDriftingMembers.add(address);
            }
        }
        if (!timeDriftingMembers.isEmpty()) {
            if (timeDriftingMembers.size() > 10) {
                Object[] shortenedList = Arrays.copyOfRange(timeDriftingMembers.toArray(new String[0]), 0, 10);
                shortenedList[9] = "...";
                String message = "The member(s) time difference is greater than one minute: " + Arrays.toString(shortenedList) + ". You may experience missing/incorrect metrics!";
                this.notifier.signal(Note.Matter.MEMBER_TIME_IS_NOT_SYNC_WITH_MC_TIME.on(cluster, message));
            } else {
                String message = "The member(s) time difference is greater than one minute: " + String.valueOf(timeDriftingMembers) + ". You may experience missing/incorrect metrics!";
                this.notifier.signal(Note.Matter.MEMBER_TIME_IS_NOT_SYNC_WITH_MC_TIME.on(cluster, message));
            }
        }
    }
}

