/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.protobuf.AbstractMessage;
import com.hazelcast.cluster.Member;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiskTierConfig;
import com.hazelcast.config.EventJournalConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.config.TieredStoreConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.webmonitor.controller.dto.MapConfigDTO;
import com.hazelcast.webmonitor.controller.dto.MapDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientWithNearCacheDTO;
import com.hazelcast.webmonitor.controller.dto.client.ClientsNearCacheIntervalStatsDTO;
import com.hazelcast.webmonitor.controller.exception.OperationFailedApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.service.ClientNearCacheStatsManager;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.MapEntryViewDTO;
import com.hazelcast.webmonitor.service.MapIndexStatsManager;
import com.hazelcast.webmonitor.service.MapManager;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCMapConfig;
import com.hazelcast.webmonitor.service.client.UpdateMapConfigParameters;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.InternalObjectsUtil;
import com.hazelcast.webmonitor.utils.MemberUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MapManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MapManager.class);
    private static final int MAP_IN_MEMORY_FORMAT_CACHE_EXPIRE_DURATION_MINUTES = 10;
    private final ClientNearCacheStatsManager clientNearCacheStatsManager;
    private final MapIndexStatsManager mapIndexStatsManager;
    private final OperationDispatcher operationDispatcher;
    private final StateManager stateManager;
    private final ClusterManager clusterManager;
    private final MemberConfigService memberConfigService;
    private final LoadingCache<MapIdentifier, String> mapInMemoryFormatCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build(key -> {
        try {
            return this.getMapConfig(key.clusterName, key.mapName).getInMemoryFormat().name();
        }
        catch (OperationFailedApiException e) {
            log.warn("Couldn't load map inMemoryFormat", (Throwable)e);
            return null;
        }
    });

    public List<ClientsNearCacheIntervalStatsDTO> getClientsNearCacheSummaryStats(String cluster, String map, long time) {
        return this.clientNearCacheStatsManager.getClientsNearCacheSummaryStats(cluster, map, InstanceType.MAP, time);
    }

    public List<ClientWithNearCacheDTO> getClientsWithNearCache(String cluster, String map) {
        return this.clientNearCacheStatsManager.getClientsByDataStructure(cluster, map, InstanceType.MAP);
    }

    public SortedSet<String> getMapsWithClientNearCache(String cluster, String clientUuid) {
        return this.clientNearCacheStatsManager.getDataStructuresByClient(cluster, clientUuid, InstanceType.MAP);
    }

    public SortedSet<String> getMapIndexes(String cluster, String mapName) {
        return this.mapIndexStatsManager.getMapIndexesByMap(cluster, mapName);
    }

    public MCMapConfig getMapConfig(String cluster, String map) {
        return (MCMapConfig)this.operationDispatcher.executeOnCluster(cluster, mcClient -> mcClient.getMapConfig(map), e -> String.format("Failed to get map config for map %s on cluster %s.", map, cluster));
    }

    public MapConfigDTO getEnrichedMapConfig(String cluster, String map) {
        MCMapConfig mcMapConfig = this.getMapConfig(cluster, map);
        MapConfigDTO.MapConfigDTOBuilder resultBuilder = MapManager.toDto((MCMapConfig)mcMapConfig).toBuilder();
        this.memberConfigService.getRandomConfigFromCluster(cluster).ifPresent(config -> {
            MapConfig mapConfig = config.toEffectiveConfig().getMapConfig(map);
            TieredStoreConfig tsConfig = mapConfig.getTieredStoreConfig();
            if (tsConfig.isEnabled()) {
                DiskTierConfig diskTierConfig;
                MemoryTierConfig memoryTierConfig = tsConfig.getMemoryTierConfig();
                if (memoryTierConfig != null) {
                    resultBuilder.memoryCapacity(memoryTierConfig.getCapacity().toPrettyString());
                }
                if ((diskTierConfig = tsConfig.getDiskTierConfig()) != null) {
                    resultBuilder.deviceName(diskTierConfig.getDeviceName());
                }
            }
        });
        resultBuilder.wanReplicationRef(this.getWanReplicationOfMap(cluster, map));
        return resultBuilder.build();
    }

    public WanReplicationRef getWanReplicationOfMap(String cluster, String mapName) {
        String clusterVersion = this.clusterManager.clusterVersion(cluster);
        if (clusterVersion == null) {
            return null;
        }
        if (Version.of((String)clusterVersion).isGreaterOrEqual(Version.of((String)"5.4.0"))) {
            return this.getMapConfig(cluster, mapName).getWanReplicationRef();
        }
        return this.memberConfigService.getRandomConfigFromCluster(cluster).map(memberConfig -> memberConfig.toEffectiveConfig().getMapConfig(mapName).getWanReplicationRef()).orElse(null);
    }

    public void updateMapConfig(String cluster, UpdateMapConfigParameters parameters) {
        HashMap errorMessages = new HashMap();
        this.operationDispatcher.executeOnAllMembers(cluster, (mcClient, member) -> mcClient.updateMapConfig(member, parameters), (member, e) -> {
            errorMessages.put(member, e);
            return null;
        });
        if (!errorMessages.isEmpty()) {
            String errorMessage = errorMessages.entrySet().stream().map(it -> MapManager.buildErrorMessage((Throwable)((Throwable)it.getValue()), (String)cluster, (Member)((Member)it.getKey()), (String)parameters.getMap())).collect(Collectors.joining(System.lineSeparator()));
            throw new OperationFailedApiException(errorMessage);
        }
    }

    private static String buildErrorMessage(Throwable throwable, String cluster, Member member, String map) {
        Throwable[] throwableArray;
        if (throwable.getSuppressed().length == 0) {
            Throwable[] throwableArray2 = new Throwable[1];
            throwableArray = throwableArray2;
            throwableArray2[0] = throwable;
        } else {
            throwableArray = throwable.getSuppressed();
        }
        Throwable[] exceptions = throwableArray;
        String exceptionMessages = String.join((CharSequence)System.lineSeparator(), (CharSequence[])Arrays.stream(exceptions).filter(Objects::nonNull).map(Throwable::getMessage).toArray(String[]::new));
        return String.format("Failed to update config for map %s on cluster %s member %s:%n%s", map, cluster, MemberUtil.getMemberAddress((Member)member), exceptionMessages);
    }

    @Nonnull
    public Collection<String> getMapNames(@Nonnull String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptySet();
        }
        return state.getInstanceNames(InstanceType.MAP);
    }

    public List<MapDTO> getMaps(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.memberConfigService.getRandomConfigFromCluster(cluster).map(rowConfig -> {
            Config config = rowConfig.toEffectiveConfig();
            Map eventJournalConfigs = this.memberConfigService.getMapEventJournalConfigs(cluster);
            SortedSet maps = state.getInstanceNames(InstanceType.MAP);
            ArrayList<MapDTO> result = new ArrayList<MapDTO>(maps.size());
            for (String map : maps) {
                MapDTO.MapDTOBuilder dtoBuilder = MapDTO.builder().name(map).hasIndexes(this.mapIndexStatsManager.isIndexPresentForMap(cluster, map)).internalObject(InternalObjectsUtil.isInternalObject((String)map)).inMemoryFormat((String)this.mapInMemoryFormatCache.get((Object)new MapIdentifier(cluster, map))).dataPersistenceEnabled(config.findMapConfig(map).getDataPersistenceConfig().isEnabled());
                EventJournalConfig eventJournalConfig = (EventJournalConfig)eventJournalConfigs.get(map);
                if (eventJournalConfig != null && eventJournalConfig.isEnabled()) {
                    dtoBuilder.eventJournalEnabled(true).eventJournalCapacity((long)eventJournalConfig.getCapacity()).eventJournalTtl((long)eventJournalConfig.getTimeToLiveSeconds());
                }
                result.add(dtoBuilder.build());
            }
            return result;
        }).orElse(Collections.emptyList());
    }

    public MapEntryViewDTO getMapEntry(String cluster, String mapName, MapKeyType keyType, String key) {
        this.stateManager.verifyDataAccessEnabled(cluster);
        HazelcastInstance client = this.operationDispatcher.getHZClient(cluster);
        try {
            IMap map = client.getMap(mapName);
            Member owner = client.getPartitionService().getPartition((Object)key).getOwner();
            EntryView entry = map.getEntryView(keyType.fromString(key));
            return entry != null ? this.toDto(entry, owner) : null;
        }
        catch (SecurityException e) {
            throw new OperationFailedApiException("Failed to read map entry due to insufficient permissions", (Throwable)e);
        }
        catch (HazelcastSerializationException e) {
            throw new OperationFailedApiException(String.format("Failed to deserialize map entry. Make sure that you use a client config file with relevant serialization configuration for your cluster client config. Exception message: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            throw new OperationFailedApiException(String.format("Failed to read map entry: %s", e.getMessage()), (Throwable)e);
        }
    }

    public void clearMap(String cluster, String mapName) {
        this.stateManager.verifyDataAccessEnabled(cluster);
        try {
            HazelcastInstance client = this.operationDispatcher.getHZClient(cluster);
            if (this.stateManager.getLatestState(cluster).getInstanceNames(InstanceType.MAP).contains(mapName)) {
                client.getMap(mapName).clear();
            }
        }
        catch (Exception e) {
            throw new OperationFailedApiException(String.format("Failed to clear map: %s", e.getMessage()), (Throwable)e);
        }
    }

    private static MapConfigDTO toDto(MCMapConfig mapConfig) {
        return MapConfigDTO.builder().memoryFormat(mapConfig.getInMemoryFormat().name()).backupCount(mapConfig.getBackupCount()).asyncBackupCount(mapConfig.getAsyncBackupCount()).timeToLiveSeconds(mapConfig.getTimeToLiveSeconds()).maxIdleSeconds(mapConfig.getMaxIdleSeconds()).maxSize(mapConfig.getMaxSize()).maxSizePolicy(mapConfig.getMaxSizePolicy().name()).readBackupData(mapConfig.isReadBackupData()).evictionPolicy(mapConfig.getEvictionPolicy().name()).mergePolicy(mapConfig.getMergePolicy()).wanReplicationRef(mapConfig.getWanReplicationRef()).build();
    }

    private MapEntryViewDTO toDto(EntryView<?, ?> entry, Member keyOwnerMember) {
        Object value = entry.getValue();
        MapEntryViewDTO dto = new MapEntryViewDTO();
        dto.setValue(value instanceof GenericRecord || value instanceof AbstractMessage ? value.toString() : value);
        dto.setValueClass(value != null ? value.getClass().getName() : "null");
        dto.setMemoryCost(entry.getCost());
        dto.setCreationTime(entry.getCreationTime());
        dto.setExpirationTime(entry.getExpirationTime());
        dto.setHits(entry.getHits());
        dto.setLastAccessTime(entry.getLastAccessTime());
        dto.setLastStoredTime(entry.getLastStoredTime());
        dto.setLastUpdateTime(entry.getLastUpdateTime());
        dto.setVersion(entry.getVersion());
        dto.setTtl(entry.getTtl());
        dto.setMaxIdle(entry.getMaxIdle());
        dto.setKeyOwnerMember(MemberUtil.getMemberAddress((Member)keyOwnerMember));
        return dto;
    }

    @ConstructorProperties(value={"clientNearCacheStatsManager", "mapIndexStatsManager", "operationDispatcher", "stateManager", "clusterManager", "memberConfigService"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    MapManager(ClientNearCacheStatsManager clientNearCacheStatsManager, MapIndexStatsManager mapIndexStatsManager, OperationDispatcher operationDispatcher, StateManager stateManager, ClusterManager clusterManager, MemberConfigService memberConfigService) {
        this.clientNearCacheStatsManager = clientNearCacheStatsManager;
        this.mapIndexStatsManager = mapIndexStatsManager;
        this.operationDispatcher = operationDispatcher;
        this.stateManager = stateManager;
        this.clusterManager = clusterManager;
        this.memberConfigService = memberConfigService;
    }
}

