/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.webmonitor.console.ConsoleManager;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.UpdateClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.jet.JetStatus;
import com.hazelcast.webmonitor.controller.exception.ClientFailedToStartApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.hz.req.state.LicenseDTO;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.hz.req.state.NodeState;
import com.hazelcast.webmonitor.model.hz.req.state.Version;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.repositories.sql.ClusterRepository;
import com.hazelcast.webmonitor.service.BrowserHeartBeatEvent;
import com.hazelcast.webmonitor.service.ClientConfigSanitizer;
import com.hazelcast.webmonitor.service.ClusterRemovedEvent;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.MCClientManager;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.NextVersionDeterminer;
import com.hazelcast.webmonitor.service.OperationDispatcher;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.client.MCClient;
import com.hazelcast.webmonitor.service.exception.InvalidClusterConnectionConfigException;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.sql.JdbiHistories;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ClusterManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterManager.class);
    private final ClusterRepository repository;
    private final JdbiHistories histories;
    private final OperationDispatcher operationDispatcher;
    private final MCClientManager clientManager;
    private final StateManager stateManager;
    private final MemberManager memberManager;
    private final Notifier notifier;
    private final ApplicationEventPublisher publisher;
    private final MemberConfigService memberConfigService;
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final ClientConfigSanitizer clientConfigSanitizer;
    private final NextVersionDeterminer nextVersionDeterminer;

    @EventListener(value={ApplicationStartedEvent.class})
    public void onApplicationStartedEvent() {
        List enabledClusters = this.repository.getEnabledClusters();
        log.info("Connecting to {} enabled cluster(s) on startup.", (Object)enabledClusters.size());
        enabledClusters.forEach(cluster -> {
            try {
                ClientConfig config = cluster.createClientConfig();
                this.clientManager.connect(config);
            }
            catch (ClientFailedToStartApiException config) {
            }
            catch (Exception e) {
                log.warn("Failed to start client for cluster {}.", (Object)cluster.getName(), (Object)e);
            }
        });
    }

    public void add(ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = this.repository.add(configType, configFileContent, enabled);
        this.connect(cluster);
    }

    public void add(AddClusterRequestDTO dto) {
        ClusterModel cluster = this.repository.add(dto);
        this.connect(cluster);
    }

    private void connect(ClusterModel cluster) {
        ClientConfig clientConfig = cluster.createClientConfig();
        if (cluster.isEnabled()) {
            this.clientManager.connect(clientConfig);
        }
    }

    public void update(String clusterName, ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = this.repository.update(clusterName, configType, configFileContent, enabled);
        this.removeConsoleConfiguration(clusterName);
        this.reconnect(clusterName, cluster);
    }

    public boolean createOrUpdateCluster(ClusterModel cluster) throws InvalidClusterConnectionConfigException {
        if (!cluster.hasConsistentClusterName()) {
            throw new InvalidClusterConnectionConfigException(cluster.getName(), cluster.createClientConfig().getClusterName());
        }
        this.clientManager.disconnect(cluster.getName());
        boolean update = this.repository.insertOrUpdate(cluster);
        this.connect(cluster);
        return update;
    }

    public void update(String clusterName, UpdateClusterRequestDTO dto) {
        ClusterModel cluster = this.repository.update(clusterName, dto);
        this.removeConsoleConfiguration(clusterName);
        this.reconnect(clusterName, cluster);
    }

    private void reconnect(String clusterName, ClusterModel cluster) {
        this.clientManager.disconnect(clusterName);
        this.connect(cluster);
    }

    public void remove(String cluster) {
        log.debug("Removing cluster {}", (Object)cluster);
        this.removeConsoleConfiguration(cluster);
        this.histories.removeByCluster(cluster);
        this.repository.remove(cluster);
        this.clientManager.disconnect(cluster);
        this.publisher.publishEvent((ApplicationEvent)new ClusterRemovedEvent(cluster));
    }

    private void removeConsoleConfiguration(String cluster) {
        try {
            ClusterModel model = this.repository.getCluster(cluster);
            Path path = this.homeDirectoryProvider.get().resolve("clc").resolve("configs").resolve(model.getId());
            ConsoleManager.removeConsoleConfig((Path)path);
        }
        catch (NoClusterApiException noClusterApiException) {
            // empty catch block
        }
    }

    public ClusterModel getCluster(String cluster) {
        ClusterModel rawModel = this.repository.getCluster(cluster);
        String clientConfig = rawModel.getClientConfig();
        ClusterModel.ClientConfigType clientConfigType = rawModel.getClientConfigType();
        if (clientConfigType == null || StringUtil.isNullOrEmptyAfterTrim((String)clientConfig)) {
            return rawModel;
        }
        if (clientConfigType == ClusterModel.ClientConfigType.XML) {
            clientConfig = this.clientConfigSanitizer.sanitizeXmlConfig(clientConfig);
        } else if (clientConfigType == ClusterModel.ClientConfigType.YAML) {
            clientConfig = this.clientConfigSanitizer.sanitizeYamlConfig(clientConfig);
        }
        return rawModel.toBuilder().clientConfig(clientConfig).build();
    }

    public List<String> getAllClusterNames() {
        return this.repository.getAllClusterNames();
    }

    public List<ClusterModel> getAllClusterConfigs() {
        return this.repository.getAllClusters();
    }

    public List<String> getConnectedClusterNames() {
        return this.clientManager.getConnectedClusters().stream().sorted(String::compareToIgnoreCase).toList();
    }

    public void changeState(String cluster, ClusterState newState) {
        this.operationDispatcher.executeOnCluster(cluster, mcClient -> mcClient.changeClusterState(newState), e -> String.format("Failed to change state of cluster %s.", cluster));
    }

    public com.hazelcast.version.Version rollingUpgradeNextVersion(String cluster) {
        String clusterVersion = this.clusterVersion(cluster);
        AllState state = this.stateManager.getLatestState(cluster);
        Optional<Version> maxMemberVersion = Objects.requireNonNull(state).getMemberStates().stream().map(memberState -> memberState.getNodeState().getMemberVersion()).max(Version::compareTo);
        return this.nextVersionDeterminer.getNextVersion(clusterVersion, maxMemberVersion);
    }

    public void changeVersion(String cluster, com.hazelcast.version.Version newVersion) {
        this.operationDispatcher.executeOnCluster(cluster, mcClient -> mcClient.changeClusterVersion(newVersion), e -> String.format("Failed to change version of cluster %s.", cluster));
    }

    public void shutdown(String cluster) {
        this.operationDispatcher.executeOnClusterAsync(cluster, MCClient::shutdownCluster, e -> String.format("Failed to shutdown cluster %s.", cluster));
    }

    Map<String, String> getVersionMismatchMembers(String cluster) {
        HashMap<String, String> versionMismatchMembers = new HashMap<String, String>();
        AllState state = this.stateManager.getLatestState(cluster);
        String clusterVersion = ClusterManager.clusterVersion((AllState)state);
        if (clusterVersion != null) {
            for (Map.Entry stateEntry : state.getMemberStates().entries()) {
                MemberState memberState = (MemberState)stateEntry.getValue();
                String address = memberState.getAddress();
                String version = memberState.getNodeState().getMemberVersion().toShortFormat();
                if (version.equals(clusterVersion)) continue;
                versionMismatchMembers.put(address, version);
            }
        }
        return versionMismatchMembers;
    }

    public boolean isRollingUpgradeInProgress(String cluster) {
        return !this.getVersionMismatchMembers(cluster).isEmpty();
    }

    public void runVersionMismatchDetection(String cluster) {
        Map versionMismatchMembers = this.getVersionMismatchMembers(cluster);
        String clusterVersion = this.clusterVersion(cluster);
        if (!versionMismatchMembers.isEmpty()) {
            String version = "";
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : versionMismatchMembers.entrySet()) {
                String address = (String)entry.getKey();
                version = (String)entry.getValue();
                sb.append(address).append(",");
            }
            String message = "The current cluster version is " + clusterVersion + " whereas node(s) [" + String.valueOf(sb) + "]'s version is " + version;
            this.notifier.signal(Note.Matter.RECEIVED_ROLLING_UPGRADE_INDICATION.on(cluster, message));
        }
    }

    public String clusterVersion(String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        return ClusterManager.clusterVersion((AllState)state);
    }

    private static String clusterVersion(AllState state) {
        if (state == null) {
            return null;
        }
        return state.getMemberStates().stream().map(MemberState::getNodeState).map(NodeState::getClusterVersion).map(Version::toShortFormat).findFirst().orElse(null);
    }

    public Map<String, String> getConnectedClusterVersions() {
        HashMap<String, String> versions = new HashMap<String, String>();
        this.getConnectedClusterNames().forEach(clusterName -> versions.put((String)clusterName, this.clusterVersion(clusterName)));
        return versions;
    }

    public Optional<LicenseDTO> getClusterLicense(String cluster) {
        return this.stateManager.getClusterLicense(cluster);
    }

    public Map<String, Long> getAllClusterLicenseExpirations() {
        return this.stateManager.getClusterNames().stream().map(clusterName -> Map.entry(clusterName, this.stateManager.getClusterLicense(clusterName))).filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((LicenseDTO)((Optional)entry.getValue()).get()).getExpirationTime()));
    }

    public JetStatus getJetStatus(String cluster) {
        return this.memberConfigService.asMap(cluster).values().stream().map(arg_0 -> ((MemberManager)this.memberManager).getJetStatus(arg_0)).reduce(JetStatus.UNKNOWN, (subtotal, element) -> {
            if (element == JetStatus.DISABLED || subtotal == JetStatus.DISABLED) {
                return JetStatus.DISABLED;
            }
            if (element == JetStatus.UNKNOWN) {
                return subtotal;
            }
            return element;
        });
    }

    public void verifyClusterConnected(String cluster) {
        if (!this.isClusterConnected(cluster)) {
            throw new NoClusterApiException(cluster);
        }
    }

    public boolean isClusterConnected(String cluster) {
        return this.getConnectedClusterNames().contains(cluster);
    }

    public Stream<Note> anyNotifications(String cluster) {
        this.publisher.publishEvent((Object)new BrowserHeartBeatEvent(cluster));
        return Arrays.stream(this.notifier.notes(cluster));
    }

    public ClientConfig getRawClientConfig(String clusterName) {
        ClusterModel rawModel = this.repository.getCluster(clusterName);
        return rawModel.createClientConfig();
    }

    @ConstructorProperties(value={"repository", "histories", "operationDispatcher", "clientManager", "stateManager", "memberManager", "notifier", "publisher", "memberConfigService", "homeDirectoryProvider", "clientConfigSanitizer", "nextVersionDeterminer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterManager(ClusterRepository repository, JdbiHistories histories, OperationDispatcher operationDispatcher, MCClientManager clientManager, StateManager stateManager, MemberManager memberManager, Notifier notifier, ApplicationEventPublisher publisher, MemberConfigService memberConfigService, HomeDirectoryProvider homeDirectoryProvider, ClientConfigSanitizer clientConfigSanitizer, NextVersionDeterminer nextVersionDeterminer) {
        this.repository = repository;
        this.histories = histories;
        this.operationDispatcher = operationDispatcher;
        this.clientManager = clientManager;
        this.stateManager = stateManager;
        this.memberManager = memberManager;
        this.notifier = notifier;
        this.publisher = publisher;
        this.memberConfigService = memberConfigService;
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.clientConfigSanitizer = clientConfigSanitizer;
        this.nextVersionDeterminer = nextVersionDeterminer;
    }
}

