/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.oidc;

import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticationException;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticator;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Response;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponseParser;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponseParser;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.IDTokenClaimsSet;
import com.nimbusds.openid.connect.sdk.validators.IDTokenValidator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class UserInfoRetrieval {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserInfoRetrieval.class);
    private final HttpSession session;
    private final URI requestURI;
    private final OidcConfig config;

    UserInfoRetrieval(HttpSession session, URI requestURI, OidcConfig config) {
        this.session = session;
        this.requestURI = requestURI;
        this.config = config;
    }

    private void failOnErrorResponse(Response resp, String exceptionMessagePrefix) {
        if (resp instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)resp;
            ErrorObject error = errorResponse.getErrorObject();
            throw new OidcAuthenticationException(exceptionMessagePrefix + OidcAuthenticator.describeError((ErrorObject)error));
        }
    }

    OidcAuthenticator.Tokens fetchTokens() throws ParseException {
        AuthorizationCode authCode = this.extractAuthCode();
        log.debug("Received auth code {}.", (Object)authCode);
        OidcAuthenticator.Tokens tokens = this.retrieveTokens(authCode);
        log.debug("Retrieved tokens {}.", (Object)tokens);
        return tokens;
    }

    JSONObject fetchUserInfo(OidcAuthenticator.Tokens tokens) {
        IDTokenClaimsSet idTokenClaims = this.verifyIdToken(tokens.getIdToken(), (String)this.session.getAttribute("oidc_nonce"));
        log.debug("ID Token contains the following claims: {}", (Object)idTokenClaims.toJSONString());
        JSONObject userInfo = this.fetchUserInfo(tokens.getAccessToken());
        log.debug("UserInfo: {}", (Object)userInfo);
        return userInfo;
    }

    private AuthorizationCode extractAuthCode() throws ParseException {
        String state = (String)this.session.getAttribute("oidc_state");
        AuthenticationResponse authResp = AuthenticationResponseParser.parse((URI)this.requestURI);
        if (authResp instanceof AuthenticationErrorResponse) {
            AuthenticationErrorResponse errorResponse = (AuthenticationErrorResponse)authResp;
            ErrorObject error = errorResponse.getErrorObject();
            throw new OidcAuthenticationException("Received error response instead of AuthenticationResponse: " + OidcAuthenticator.describeError((ErrorObject)error));
        }
        AuthenticationSuccessResponse successResponse = (AuthenticationSuccessResponse)authResp;
        if (!state.equals(successResponse.getState().getValue())) {
            throw new OidcAuthenticationException("State in the received AuthenticationResponse doesn't match the previously sent state.");
        }
        return successResponse.getAuthorizationCode();
    }

    private IDTokenClaimsSet verifyIdToken(JWT idToken, String nonce) {
        try {
            JWSAlgorithm jwsAlg = JWSAlgorithm.parse((String)this.config.getJwsAlgorithm());
            IDTokenValidator validator = new IDTokenValidator(new Issuer(this.config.getIssuer()), new ClientID(this.config.getClientId()), jwsAlg, URI.create(this.config.getJwkSetEndpoint()).toURL());
            return validator.validate(idToken, new Nonce(nonce));
        }
        catch (MalformedURLException e) {
            throw new SecurityConfigApiException("Failed to create validator for ID token.", (Throwable)e);
        }
        catch (JOSEException | BadJOSEException e) {
            throw new OidcAuthenticationException("Failed to verify ID token.", e);
        }
    }

    private OidcAuthenticator.Tokens retrieveTokens(AuthorizationCode authCode) {
        try {
            HashMap<String, List<String>> extraParams = new HashMap<String, List<String>>();
            if (this.config.isSendClientInfoInTokenRequest()) {
                extraParams.put("client_id", List.of(this.config.getClientId()));
                extraParams.put("client_secret", List.of(this.config.getClientSecret()));
            }
            TokenRequest tokenReq = new TokenRequest(new URI(this.config.getTokenEndpoint()), (ClientAuthentication)new ClientSecretBasic(new ClientID(this.config.getClientId()), new Secret(this.config.getClientSecret())), (AuthorizationGrant)new AuthorizationCodeGrant(authCode, new URI(this.config.getRedirectURL())), null, null, extraParams);
            HTTPRequest request = tokenReq.toHTTPRequest();
            UserInfoRetrieval.logRequest((String)"Token", (HTTPRequest)request);
            HTTPResponse tokenHTTPResp = request.send();
            UserInfoRetrieval.logResponse((String)"Token", (HTTPResponse)tokenHTTPResp);
            TokenResponse tokenResponse = OIDCTokenResponseParser.parse((HTTPResponse)tokenHTTPResp);
            this.failOnErrorResponse((Response)tokenResponse, "Received error response instead of TokenResponse: ");
            AccessTokenResponse accessTokenResponse = (AccessTokenResponse)tokenResponse;
            return new OidcAuthenticator.Tokens(accessTokenResponse.getTokens().toOIDCTokens().getAccessToken(), accessTokenResponse.getTokens().toOIDCTokens().getIDToken());
        }
        catch (URISyntaxException e) {
            throw new SecurityConfigApiException("Failed to create token request.", (Throwable)e);
        }
        catch (SerializeException | IOException e) {
            throw new OidcAuthenticationException("Failed to retrieve tokens.", e);
        }
        catch (ParseException e) {
            throw new OidcAuthenticationException("Failed to parse token response.", (Throwable)e);
        }
    }

    private JSONObject fetchUserInfo(AccessToken accessToken) {
        try {
            HTTPRequest.Method httpMethod = HTTPRequest.Method.valueOf((String)this.config.getUserInfoRequestHttpMethod());
            HTTPRequest request = new UserInfoRequest(new URI(this.config.getUserInfoEndpoint()), httpMethod, accessToken).toHTTPRequest();
            UserInfoRetrieval.logRequest((String)"UserInfo", (HTTPRequest)request);
            HTTPResponse httpResponse = request.send();
            UserInfoRetrieval.logResponse((String)"UserInfo", (HTTPResponse)httpResponse);
            UserInfoResponse response = UserInfoResponse.parse((HTTPResponse)httpResponse);
            this.failOnErrorResponse((Response)response, "Received error response instead of UserInfo response: ");
            UserInfoSuccessResponse successResponse = (UserInfoSuccessResponse)response;
            return successResponse.getUserInfo().toJSONObject();
        }
        catch (URISyntaxException e) {
            throw new SecurityConfigApiException("Failed to fetch UserInfo.", (Throwable)e);
        }
        catch (SerializeException | IOException e) {
            throw new OidcAuthenticationException("Failed to fetch UserInfo.", e);
        }
        catch (ParseException e) {
            throw new OidcAuthenticationException("Failed to parse UserInfo response.", (Throwable)e);
        }
    }

    private static void logRequest(String requestType, HTTPRequest request) {
        String body = HTTPRequest.Method.POST.equals((Object)request.getMethod()) ? request.getBody() : request.getURL().getQuery();
        log.debug("{} request Method: {} URL: {}\nHeaders:\n{}Body:\n{}", new Object[]{requestType, request.getMethod(), request.getURL(), UserInfoRetrieval.mapToString((Map)request.getHeaderMap()), body});
    }

    private static void logResponse(String responseType, HTTPResponse response) {
        String messageTemplate = "{} response Status Code: {} Status Message: {}\nHeaders:\n{}Content:\n{}";
        log.debug(messageTemplate, new Object[]{responseType, response.getStatusCode(), response.getStatusMessage(), UserInfoRetrieval.mapToString((Map)response.getHeaderMap()), response.getBody()});
    }

    @Nonnull
    private static String mapToString(Map<String, List<String>> map) {
        StringBuilder headers = new StringBuilder();
        for (Map.Entry<String, List<String>> header : map.entrySet()) {
            headers.append(String.format("%s => %s%n", header.getKey(), header.getValue()));
        }
        return headers.toString();
    }
}

