/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.oidc;

import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.security.spi.SecurityConfigApiException;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.security.spi.impl.oidc.AuthenticationCompletion;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcSecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.oidc.PersistentOidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.UserInfoRetrieval;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.Nonce;
import jakarta.servlet.http.HttpSession;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"!hzcloud"})
public final class OidcAuthenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAuthenticator.class);
    static final String SESSION_ATTR_OIDC_STATE = "oidc_state";
    static final String SESSION_ATTR_OIDC_NONCE = "oidc_nonce";
    private final PersistentOidcConfig oidcConfig;
    private final AuthenticationManagerImpl authManager;

    public OidcAuthenticator(GroupedSettingsDAO groupedSettingsDAO, AuthenticationManagerImpl authManager) {
        this.oidcConfig = new PersistentOidcConfig(groupedSettingsDAO);
        this.authManager = authManager;
    }

    public String generateAuthenticationRequestURL(HttpSession session) {
        AuthenticationRequest authenticationRequest;
        this.ensureOidcConfigured();
        State state = new State();
        Nonce nonce = new Nonce();
        session.setAttribute(SESSION_ATTR_OIDC_STATE, (Object)state.toString());
        session.setAttribute(SESSION_ATTR_OIDC_NONCE, (Object)nonce.toString());
        OidcConfig config = this.oidcConfig.get();
        try {
            authenticationRequest = new AuthenticationRequest(new URI(config.getAuthorizationEndpoint()), new ResponseType(new ResponseType.Value[]{ResponseType.Value.CODE}), Scope.parse((String)config.getScope()), new ClientID(config.getClientId()), new URI(config.getRedirectURL()), state, nonce);
        }
        catch (URISyntaxException e) {
            throw new SecurityConfigApiException("Failed to generate authentication request URL.", (Throwable)e);
        }
        return authenticationRequest.toURI().toString();
    }

    public String completeAuthentication(HttpSession session, URI requestURI) throws ParseException {
        LOGGER.debug("OpenID Connect Configuration: {}", (Object)this.oidcConfig.get());
        return new AuthenticationCompletion(session, this.oidcConfig.get()).completeAuthentication(new UserInfoRetrieval(session, requestURI, this.oidcConfig.get()));
    }

    static String describeError(ErrorObject error) {
        return String.format("Code=%s HttpStatusCode=%s URI=%s Description=%s", error.getCode(), error.getHTTPStatusCode(), error.getURI(), error.getDescription());
    }

    private void ensureOidcConfigured() {
        if (!(this.authManager.getCurrentSecurityProvider() instanceof OidcSecurityProvider)) {
            throw new SecurityConfigApiException("To use single sign-on, you need to configure OpenID Connect security provider first.");
        }
    }
}

