/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.oidc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToAuthoritiesMapper;
import com.hazelcast.webmonitor.security.spi.impl.GroupsToRolesMappingConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticationException;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcAuthenticator;
import com.hazelcast.webmonitor.security.spi.impl.oidc.OidcConfig;
import com.hazelcast.webmonitor.security.spi.impl.oidc.UserInfoRetrieval;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import com.hazelcast.webmonitor.utils.StringUtil;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpSession;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

class AuthenticationCompletion {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationCompletion.class);
    private final HttpSession session;
    private final OidcConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String completeAuthentication(UserInfoRetrieval userInfoRetrieval) throws ParseException {
        try {
            OidcAuthenticator.Tokens tokens = userInfoRetrieval.fetchTokens();
            JSONObject userInfo = userInfoRetrieval.fetchUserInfo(tokens);
            UsernamePasswordAuthenticationToken authentication = this.mapUserInfoJsonToAuthentication(tokens, userInfo);
            SecurityContextUtil.setAuthentication((Authentication)authentication);
            String string = (String)authentication.getPrincipal();
            return string;
        }
        finally {
            this.session.removeAttribute("oidc_state");
            this.session.removeAttribute("oidc_nonce");
        }
    }

    private UsernamePasswordAuthenticationToken mapUserInfoJsonToAuthentication(OidcAuthenticator.Tokens tokens, JSONObject userInfo) {
        String userId = this.extractUserId(userInfo, tokens, this.config.getUserIdClaimName());
        log.debug("UserId for user: {}", (Object)userId);
        List groups = this.extractGroups(userInfo, tokens, this.config.getGroupsClaimName());
        log.debug("Groups for user: {}", (Object)groups);
        Set roles = GroupsToAuthoritiesMapper.mapGroupsToAuthoritiesOrThrow((Collection)groups, (GroupsToRolesMappingConfig)this.config.getGroupsToRolesMappingConfig());
        return new UsernamePasswordAuthenticationToken((Object)userId, null, (Collection)roles);
    }

    private String extractUserId(JSONObject userInfo, OidcAuthenticator.Tokens tokens, String userIdClaimName) {
        try {
            return Optional.ofNullable(userInfo.getAsString(userIdClaimName)).or(() -> this.extractUserIdFromIdToken(tokens.getIdToken(), userIdClaimName)).or(() -> this.extractUserIdFromAccessToken(tokens.getAccessToken(), userIdClaimName)).filter(id -> !StringUtil.isNullOrEmptyAfterTrim((String)id)).orElseThrow(() -> new OidcAuthenticationException("No '" + this.config.getUserIdClaimName() + "' claim returned from the OpenID provider."));
        }
        catch (Exception e) {
            log.warn("Exception occurred while extracting '{}' from the OpenID provider's tokens.", (Object)userIdClaimName, (Object)e);
            throw new OidcAuthenticationException("No '" + this.config.getUserIdClaimName() + "' claim returned from the OpenID provider.");
        }
    }

    private Optional<String> extractUserIdFromIdToken(JWT idToken, String userIdClaimName) {
        JWTClaimsSet idTokenJwtClaimsSet = idToken.getJWTClaimsSet();
        return Optional.ofNullable(idTokenJwtClaimsSet.getStringClaim(userIdClaimName));
    }

    private Optional<String> extractUserIdFromAccessToken(AccessToken accessToken, String userIdClaimName) {
        JsonNode jsonNode = this.extractJsonNode(accessToken);
        JsonNode userIdNode = jsonNode.get(userIdClaimName);
        if (userIdNode == null || userIdNode.asText().isEmpty()) {
            log.warn("Can not extract '{}' from the OpenID provider's access token.", (Object)userIdClaimName);
            return Optional.empty();
        }
        return Optional.ofNullable(userIdNode.asText());
    }

    private JsonNode extractJsonNode(AccessToken accessToken) throws JsonProcessingException {
        String[] parts = accessToken.getValue().split("\\.");
        if (parts.length <= 1) {
            log.warn("Access token is broken.");
            return NullNode.getInstance();
        }
        String payload = new String(Base64.getUrlDecoder().decode(parts[1]), StandardCharsets.UTF_8);
        return SerializationUtil.OBJECT_MAPPER.readTree(payload);
    }

    private List<String> extractGroups(JSONObject userInfo, OidcAuthenticator.Tokens tokens, String groupsClaimName) {
        try {
            String[] claimPaths = groupsClaimName.split("\\.");
            return this.extractGroupsFromUserInfo(userInfo, claimPaths).or(() -> this.extractGroupsFromIdToken(tokens.getIdToken(), claimPaths)).or(() -> this.extractGroupsFromAccessToken(tokens.getAccessToken(), claimPaths)).filter(group -> !group.isEmpty()).orElseThrow(() -> new OidcAuthenticationException("No '" + this.config.getGroupsClaimName() + "' claim returned from the OpenID provider."));
        }
        catch (Exception e) {
            log.warn("Exception occurred while extracting '{}' from the OpenID provider's tokens.", (Object)groupsClaimName, (Object)e);
            throw new OidcAuthenticationException("No '" + this.config.getGroupsClaimName() + "' claim returned from the OpenID provider.");
        }
    }

    private Optional<List<String>> extractGroupsFromIdToken(JWT idToken, String[] claimPaths) {
        List groups = Collections.emptyList();
        for (String claimPath : claimPaths) {
            groups = idToken.getJWTClaimsSet().getStringListClaim(claimPath);
        }
        return Optional.ofNullable(groups);
    }

    private Optional<List<String>> extractGroupsFromAccessToken(AccessToken accessToken, String[] claimPaths) {
        List groups = Collections.emptyList();
        for (String claimPath : claimPaths) {
            groups = this.extractJsonNode(accessToken).findValuesAsText(claimPath);
        }
        return groups.isEmpty() ? Optional.empty() : Optional.of(groups);
    }

    private Optional<List<String>> extractGroupsFromUserInfo(JSONObject userInfo, String[] claimPath) {
        Object groupsJson = userInfo;
        for (String claimPathValue : claimPath) {
            groupsJson = groupsJson.get((Object)claimPathValue);
        }
        if (!(groupsJson instanceof JSONArray)) {
            return Optional.empty();
        }
        return Optional.of(Arrays.stream(((JSONArray)groupsJson).toArray()).filter(String.class::isInstance).map(String.class::cast).toList());
    }

    @ConstructorProperties(value={"session", "config"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AuthenticationCompletion(HttpSession session, OidcConfig config) {
        this.session = session;
        this.config = config;
    }
}

