/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.spi.impl.builtin;

import com.hazelcast.webmonitor.model.sql.UserCredentialsModel;
import com.hazelcast.webmonitor.repositories.sql.UserCredentialsDAO;
import com.hazelcast.webmonitor.security.spi.impl.builtin.TokenBasedAuthenticationToken;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class DefaultAuthenticationProvider
implements AuthenticationProvider {
    private final UserCredentialsDAO userDAO;
    private final AuthTokenManager authTokenManager;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Optional userOptional;
        if (authentication.getPrincipal() instanceof AnonymousAuthenticationToken) {
            return authentication;
        }
        String username = authentication.getName();
        if (authentication instanceof TokenBasedAuthenticationToken) {
            if (this.authTokenManager == null) {
                throw new BadCredentialsException("Runtime configuration does not support tokens.");
            }
            String token = (String)authentication.getCredentials();
            if (!this.authTokenManager.validate(token)) {
                throw new BadCredentialsException("Invalid token!");
            }
            userOptional = this.userDAO.findByUsername(username);
        } else {
            String password = (String)authentication.getCredentials();
            userOptional = this.userDAO.login(username, password);
        }
        if (userOptional.isPresent()) {
            UserCredentialsModel user = (UserCredentialsModel)userOptional.get();
            ArrayList<SimpleGrantedAuthority> grantedAuths = new ArrayList<SimpleGrantedAuthority>();
            if (!"".equals(user.getRole())) {
                grantedAuths.add(new SimpleGrantedAuthority(user.getRole()));
            }
            return new UsernamePasswordAuthenticationToken((Object)user.getUsername(), null, grantedAuths);
        }
        throw new BadCredentialsException("Wrong username/password!");
    }

    public boolean supports(Class<?> authentication) {
        return true;
    }

    @ConstructorProperties(value={"userDAO", "authTokenManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DefaultAuthenticationProvider(UserCredentialsDAO userDAO, AuthTokenManager authTokenManager) {
        this.userDAO = userDAO;
        this.authTokenManager = authTokenManager;
    }
}

