/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security.cloud;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.util.StringUtils;

public class CloudOidcUserService
extends OidcUserService {
    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser oidcUser = super.loadUser(userRequest);
        Collection authorities = oidcUser.getAuthorities().stream().filter(Predicate.not(OidcUserAuthority.class::isInstance)).collect(Collectors.toSet());
        authorities.add(new OidcUserAuthority("ROLE_CLOUD_USER", userRequest.getIdToken(), oidcUser.getUserInfo()));
        ClientRegistration.ProviderDetails providerDetails = userRequest.getClientRegistration().getProviderDetails();
        String userNameAttributeName = providerDetails.getUserInfoEndpoint().getUserNameAttributeName();
        if (StringUtils.hasText((String)userNameAttributeName)) {
            return new DefaultOidcUser(authorities, oidcUser.getIdToken(), oidcUser.getUserInfo(), userNameAttributeName);
        }
        return new DefaultOidcUser(authorities, userRequest.getIdToken(), oidcUser.getUserInfo());
    }
}

