/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.firewall.HttpStatusRequestRejectedHandler;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.security.web.firewall.RequestRejectedHandler;

public class MethodAwareRequestRejectedHandler
implements RequestRejectedHandler {
    private final Set<String> allowedMethods;
    private final RequestRejectedHandler badRequest = new HttpStatusRequestRejectedHandler(HttpStatus.BAD_REQUEST.value());
    private final RequestRejectedHandler methodNotAllowed = new HttpStatusRequestRejectedHandler(HttpStatus.METHOD_NOT_ALLOWED.value());

    public void handle(HttpServletRequest request, HttpServletResponse response, RequestRejectedException ex) throws IOException, ServletException {
        String method = request.getMethod();
        if (!this.allowedMethods.contains(method)) {
            this.methodNotAllowed.handle(request, response, ex);
        } else {
            this.badRequest.handle(request, response, ex);
        }
    }

    @ConstructorProperties(value={"allowedMethods"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MethodAwareRequestRejectedHandler(Set<String> allowedMethods) {
        this.allowedMethods = allowedMethods;
    }
}

