/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.controller.dto.security.AuthTokenDTO;
import com.hazelcast.webmonitor.security.spi.impl.builtin.TokenBasedAuthenticationToken;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.utils.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class LoginAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginAuthenticationFilter.class);
    private final AuthTokenManager authTokenManager;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        Authentication authentication = this.attemptTokenAuthentication(request);
        if (authentication == null) {
            authentication = super.attemptAuthentication(request, response);
        }
        return authentication;
    }

    private Authentication attemptTokenAuthentication(HttpServletRequest request) throws AuthenticationException {
        if (!request.getMethod().equals("POST")) {
            return null;
        }
        String authToken = request.getParameter("token");
        if (!StringUtil.isNullOrEmptyAfterTrim((String)authToken)) {
            try {
                String username = this.authTokenManager.find(authToken).map(AuthTokenDTO::getUsername).orElseThrow(() -> new BadCredentialsException("Invalid token!"));
                TokenBasedAuthenticationToken authRequest = new TokenBasedAuthenticationToken(username, authToken);
                return this.getAuthenticationManager().authenticate((Authentication)authRequest);
            }
            catch (AuthenticationException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("Token authentication failed: could not read token data", (Throwable)e);
                throw new AuthenticationServiceException("Token authentication failed", (Throwable)e);
            }
        }
        return null;
    }

    @ConstructorProperties(value={"authTokenManager"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LoginAuthenticationFilter(AuthTokenManager authTokenManager) {
        this.authTokenManager = authTokenManager;
    }
}

