/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class DevModeAuthenticationFilter
implements Filter {
    private final BooleanSupplier isDevModeActive;

    public DevModeAuthenticationFilter(@NotNull BooleanSupplier isDevModeActive) {
        this.isDevModeActive = isDevModeActive;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isDevModeActive.getAsBoolean()) {
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"admin", null, Set.of(new SimpleGrantedAuthority("ROLE_ADMIN")));
            SecurityContextUtil.setAuthentication((Authentication)auth);
        }
        chain.doFilter(request, response);
    }
}

