/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.model.telemetry.UserLoginEvent;
import com.hazelcast.webmonitor.networking.IPAddressUtil;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.service.Clock;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.io.IOException;
import lombok.Generated;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;

public class CustomAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    private final UserDAO userDAO;
    private final AuditLogService auditService;
    private final Clock clock;
    private final boolean isCloudEnabled;
    private final boolean isFakeCloud;
    private final ApplicationEventPublisher eventPublisher;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.addSameSiteToCookies(response);
        super.onAuthenticationSuccess(request, response, authentication);
        this.userDAO.updateLoginTime(authentication.getName(), this.clock.currentOffsetDateTime());
        this.auditService.log(AuditableEvent.builder().typeId("MC-2001 [Auth]").message("User logged in").parameter("username", (Object)authentication.getName()).ipAddress(IPAddressUtil.getIpAddress((HttpServletRequest)request)).build());
        this.eventPublisher.publishEvent((Object)UserLoginEvent.fromRequest((HttpServletRequest)request));
    }

    private void addSameSiteToCookies(HttpServletResponse response) {
        boolean first = true;
        for (String header : response.getHeaders("Set-Cookie")) {
            String cookieWithSameSite = String.format("%s; %s", header, "SameSite=Lax");
            if (this.isCloudEnabled && !this.isFakeCloud) {
                cookieWithSameSite = String.format("%s; %s", header, "SameSite=None; Secure");
            }
            if (first) {
                response.setHeader("Set-Cookie", cookieWithSameSite);
                first = false;
                continue;
            }
            response.addHeader("Set-Cookie", cookieWithSameSite);
        }
    }

    @ConstructorProperties(value={"userDAO", "auditService", "clock", "isCloudEnabled", "isFakeCloud", "eventPublisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CustomAuthenticationSuccessHandler(UserDAO userDAO, AuditLogService auditService, Clock clock, boolean isCloudEnabled, boolean isFakeCloud, ApplicationEventPublisher eventPublisher) {
        this.userDAO = userDAO;
        this.auditService = auditService;
        this.clock = clock;
        this.isCloudEnabled = isCloudEnabled;
        this.isFakeCloud = isFakeCloud;
        this.eventPublisher = eventPublisher;
    }
}

