/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class CustomAccessDeniedHandler
implements AccessDeniedHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException {
        if (!response.isCommitted()) {
            response.setStatus(403);
            response.setContentType("application/json");
            LinkedHashMap<String, Object> errorResponse = new LinkedHashMap<String, Object>();
            errorResponse.put("timestamp", System.currentTimeMillis());
            errorResponse.put("status", 403);
            errorResponse.put("error", "Forbidden");
            errorResponse.put("message", accessDeniedException.getMessage());
            errorResponse.put("path", request.getRequestURI());
            OBJECT_MAPPER.writeValue((Writer)response.getWriter(), errorResponse);
        }
    }
}

