/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.webmonitor.model.sql.ScriptModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
public class ScriptDAO {
    private final Jdbi jdbi;

    public List<String> findNamesByUsername(String username) {
        return (List)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("SELECT script_name FROM scripts WHERE username = :username ORDER BY script_name");){
                List list = ((Query)query.bind("username", username)).mapTo(String.class).list();
                return list;
            }
        });
    }

    public void insertOrUpdate(ScriptModel script) {
        this.jdbi.useTransaction(handle -> {
            try (Update update = handle.createUpdate("MERGE INTO scripts (username, script_name, language, code) VALUES (:username, :scriptName, :language, :code)");){
                ((Update)update.bindBean((Object)script)).execute();
            }
        });
    }

    public Optional<ScriptModel> findByUsernameAndName(String username, String name) {
        return (Optional)this.jdbi.withHandle(handle -> {
            try (Query query = handle.createQuery("SELECT username, script_name, language, code FROM scripts WHERE username = :username AND script_name = :scriptName");){
                Optional optional = ((Query)((Query)query.bind("username", username)).bind("scriptName", name)).mapToBean(ScriptModel.class).findFirst();
                return optional;
            }
        });
    }

    public void deleteByUsernameTx(Handle handle, String username) {
        try (Update update = handle.createUpdate("DELETE FROM scripts WHERE username = :username");){
            ((Update)update.bind("username", username)).execute();
        }
    }

    public void delete(String username, String name) {
        this.jdbi.useHandle(handle -> {
            try (Update update = handle.createUpdate("DELETE FROM scripts WHERE username = :username AND script_name = :scriptName");){
                ((Update)((Update)update.bind("username", username)).bind("scriptName", name)).execute();
            }
        });
    }

    @ConstructorProperties(value={"jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ScriptDAO(Jdbi jdbi) {
        this.jdbi = jdbi;
    }
}

