/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.repositories.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.RoutingMode;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.UpdateClusterRequestDTO;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.model.sql.client.ClientFilteringConfigModel;
import com.hazelcast.webmonitor.repositories.sql.ClientFilteringDAO;
import com.hazelcast.webmonitor.repositories.sql.ClusterDAO;
import com.hazelcast.webmonitor.repositories.sql.SqlExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

/*
 * Exception performing whole class analysis ignored.
 */
@Repository
public class ClusterRepository {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterRepository.class);
    private final ClusterDAO clusterDAO;
    private final ClientFilteringDAO clientFilteringDAO;
    private final Jdbi jdbi;

    public ClusterModel add(ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = new ClusterModel(configType, configFileContent, enabled);
        if (cluster.createClientConfig().getNetworkConfig().getClusterRoutingConfig().getRoutingMode() != RoutingMode.ALL_MEMBERS) {
            throw new InvalidConfigurationException("RoutingMode must be configured as ALL_MEMBERS for MC.");
        }
        this.insert(cluster);
        return cluster;
    }

    public ClusterModel add(AddClusterRequestDTO dto) {
        ClusterModel cluster = dto.toModel();
        this.insert(cluster);
        return cluster;
    }

    private void insert(ClusterModel cluster) {
        try {
            ClientFilteringConfigModel filteringConfig = ClientFilteringConfigModel.defaultForCluster((String)cluster.getName());
            this.jdbi.useTransaction(handle -> {
                this.clusterDAO.insertTx(handle, cluster);
                this.clientFilteringDAO.insertConfigTx(handle, filteringConfig);
            });
        }
        catch (UnableToExecuteStatementException e) {
            log.debug("Failed to insert cluster record", (Throwable)e);
            throw SqlExceptionUtil.wrapWithApiException((UnableToExecuteStatementException)e, (String)("Cluster config " + cluster.getName() + " already exists!"));
        }
    }

    public ClusterModel update(String clusterName, ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        ClusterModel cluster = ClusterRepository.newCluster((String)clusterName, (ClusterModel.ClientConfigType)configType, (byte[])configFileContent, (boolean)enabled);
        ClientConfig clientConfig = cluster.createClientConfig();
        String parsedClientName = clientConfig.getClusterName();
        if (!parsedClientName.equals(cluster.getName())) {
            throw new InvalidConfigurationException(String.format("Uploaded config file has %s as its group name whereas name of the cluster being updated is %s.", parsedClientName, clusterName));
        }
        this.update(clusterName, cluster);
        return cluster;
    }

    public void updateEnabledStatus(String clusterName, boolean enabled) {
        int updateCount = this.clusterDAO.updateEnableStatus(clusterName, enabled);
        if (updateCount == 0) {
            throw new NoClusterApiException(clusterName);
        }
    }

    public ClusterModel update(String clusterName, UpdateClusterRequestDTO dto) {
        ClusterModel cluster = dto.toModel(clusterName);
        this.update(clusterName, cluster);
        return cluster;
    }

    private void update(String clusterName, ClusterModel cluster) {
        int updateCount = this.clusterDAO.update(clusterName, cluster);
        if (updateCount == 0) {
            throw new NoClusterApiException(clusterName);
        }
    }

    public boolean insertOrUpdate(ClusterModel model) {
        return (Boolean)this.jdbi.inTransaction(handle -> {
            Optional maybeExistingModel = this.clusterDAO.findByNameTx(handle, model.getName());
            if (maybeExistingModel.isPresent()) {
                this.clusterDAO.updateTx(handle, model.getName(), model);
                return true;
            }
            this.clusterDAO.insertTx(handle, model);
            this.clientFilteringDAO.insertConfigTx(handle, ClientFilteringConfigModel.defaultForCluster((String)model.getName()));
            return false;
        });
    }

    public void remove(String cluster) {
        this.jdbi.useTransaction(handle -> {
            this.clientFilteringDAO.findAllWithEntries(cluster).forEach(entry -> {
                this.clientFilteringDAO.deleteAllEntriesTx(handle, entry.getId());
                this.clientFilteringDAO.deleteTx(handle, entry.getId());
            });
            this.clientFilteringDAO.deleteConfigTx(handle, cluster);
            this.clusterDAO.deleteTx(handle, cluster);
        });
    }

    public ClusterModel getCluster(String cluster) {
        return (ClusterModel)this.clusterDAO.findByName(cluster).orElseThrow(() -> new NoClusterApiException(cluster));
    }

    public List<String> getAllClusterNames() {
        return this.clusterDAO.findAllClusterNames();
    }

    public List<ClusterModel> getEnabledClusters() {
        return this.clusterDAO.findEnabled();
    }

    private static ClusterModel newCluster(String clusterName, ClusterModel.ClientConfigType configType, byte[] configFileContent, boolean enabled) {
        return new ClusterModel(clusterName, configType, new String(configFileContent, StandardCharsets.UTF_8), enabled);
    }

    public List<ClusterModel> getAllClusters() {
        return this.clusterDAO.findAllClusters();
    }

    @ConstructorProperties(value={"clusterDAO", "clientFilteringDAO", "jdbi"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterRepository(ClusterDAO clusterDAO, ClientFilteringDAO clientFilteringDAO, Jdbi jdbi) {
        this.clusterDAO = clusterDAO;
        this.clientFilteringDAO = clientFilteringDAO;
        this.jdbi = jdbi;
    }
}

