/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.prometheus.ConditionalOnEnabledPrinter;
import com.hazelcast.webmonitor.prometheus.PrometheusMetricPrinter;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledPrinterCondition
extends SpringBootCondition {
    OnEnabledPrinterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Set enabledPrinterVersions = (Set)Binder.get((Environment)context.getEnvironment()).bind("hazelcast.mc.prometheus-exporter.printers", Bindable.setOf(PrometheusMetricPrinter.PrinterVersion.class)).orElse(Collections.emptySet());
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnEnabledPrinter.class.getName());
        if (attributes == null) {
            throw new IllegalStateException("%s should only be used with %s annotation".formatted(this.getClass().getSimpleName(), ConditionalOnEnabledPrinter.class.getSimpleName()));
        }
        PrometheusMetricPrinter.PrinterVersion printerVersion = (PrometheusMetricPrinter.PrinterVersion)attributes.get("value");
        if (!enabledPrinterVersions.contains(printerVersion)) {
            return ConditionOutcome.noMatch((String)("Printer is excluded by version: " + String.valueOf(printerVersion)));
        }
        return ConditionOutcome.match();
    }
}

