/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.prometheus;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.Level;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.prometheus.PrometheusAuthDetails;
import com.hazelcast.webmonitor.prometheus.PrometheusExporter;
import com.hazelcast.webmonitor.prometheus.PrometheusExporterImpl;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.springframework.http.HttpStatus;

class AuthenticatingPrometheusExporter
implements PrometheusExporter {
    private static final String EXPECTED_AUTH_HEADER_PREFIX = "Basic ";
    private final PrometheusExporterImpl delegate;
    private final String expectedAuthHeaderValue;
    private final AuditLogService auditLog;

    AuthenticatingPrometheusExporter(PrometheusExporterImpl delegate, PrometheusAuthDetails expectedAuthDetails, AuditLogService auditLog) {
        this.delegate = delegate;
        this.expectedAuthHeaderValue = EXPECTED_AUTH_HEADER_PREFIX + expectedAuthDetails.toBase64();
        this.auditLog = auditLog;
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }

    public void printExport(HttpServletRequest request, HttpServletResponse response) {
        try {
            String authHeader = request.getHeader("Authorization");
            if (authHeader == null) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("missing Authorization header");
                return;
            }
            if (!authHeader.startsWith(EXPECTED_AUTH_HEADER_PREFIX)) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("incorrect authorization scheme in Authorization header. Supported authorization scheme is: Basic");
                return;
            }
            if (!this.expectedAuthHeaderValue.equals(authHeader)) {
                response.sendError(HttpStatus.UNAUTHORIZED.value());
                this.logWarning("incorrect username or password sent in Authorization header");
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.delegate.printExport(request, response);
    }

    private void logWarning(String message) {
        this.auditLog.log(AuditableEvent.builder().typeId("MC-2010 [Prometheus Auth]").level(Level.WARN).message(message).build());
    }

    public boolean wasRequestReceived() {
        return this.delegate.wasRequestReceived();
    }
}

