/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.networking;

import jakarta.servlet.http.HttpServletRequest;
import java.util.StringTokenizer;

public final class IPAddressUtil {
    private IPAddressUtil() {
    }

    public static String trimPort(String address) {
        int delimeterIndx = address.lastIndexOf(":");
        if (delimeterIndx > -1) {
            return address.substring(0, delimeterIndx);
        }
        return address;
    }

    public static String getIpAddress(HttpServletRequest request) {
        String xForwardedForHeader = request.getHeader("X-Forwarded-For");
        if (xForwardedForHeader == null) {
            return request.getRemoteAddr();
        }
        return new StringTokenizer(xForwardedForHeader, ",").nextToken().trim();
    }
}

