/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model.sql;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.YamlClientConfigBuilder;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="array is required for JDBI mapping")
public class ClusterModel {
    private String name;
    private String id;
    private String[] memberAddresses;
    private ClientConfigType clientConfigType;
    private String clientConfig;
    private boolean enabled;

    public ClusterModel() {
    }

    public ClusterModel(String name, String[] memberAddresses, boolean enabled) {
        this.name = name;
        this.memberAddresses = memberAddresses;
        this.enabled = enabled;
        this.id = UuidUtil.newSecureUuidString();
        this.clientConfigType = null;
        this.clientConfig = null;
    }

    public ClusterModel(ClientConfigType clientConfigType, byte[] clientConfig, boolean enabled) {
        this.clientConfigType = clientConfigType;
        this.clientConfig = new String(clientConfig, StandardCharsets.UTF_8);
        this.enabled = enabled;
        this.memberAddresses = null;
        this.id = UuidUtil.newSecureUuidString();
        this.name = this.createClientConfig().getClusterName();
    }

    public ClusterModel(String name, ClientConfigType clientConfigType, String clientConfig, boolean enabled) {
        this.name = name;
        this.clientConfigType = clientConfigType;
        this.clientConfig = clientConfig;
        this.enabled = enabled;
        this.id = UuidUtil.newSecureUuidString();
        this.memberAddresses = null;
    }

    public boolean hasConsistentClusterName() {
        return this.clientConfig == null || Objects.equals(this.name, this.createClientConfig().getClusterName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterModel that = (ClusterModel)o;
        return this.enabled == that.enabled && Objects.equals(this.name, that.name) && Arrays.equals(this.memberAddresses, that.memberAddresses) && this.clientConfigType == that.clientConfigType && Objects.equals(this.clientConfig, that.clientConfig);
    }

    public int hashCode() {
        int result = Objects.hash(this.name, this.clientConfigType, this.clientConfig, this.enabled);
        result = 31 * result + Arrays.hashCode(this.memberAddresses);
        return result;
    }

    public ClientConfig createClientConfig() {
        if (this.clientConfigType == null) {
            ClientConfig config = new ClientConfig();
            config.setClusterName(this.name);
            config.getNetworkConfig().addAddress(this.memberAddresses);
            return config;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.clientConfig.getBytes(StandardCharsets.UTF_8));
        return switch (this.clientConfigType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new XmlClientConfigBuilder((InputStream)in).build();
            case 1 -> new YamlClientConfigBuilder((InputStream)in).build();
        };
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ClusterModelBuilder builder() {
        return new ClusterModelBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterModelBuilder toBuilder() {
        return new ClusterModelBuilder().name(this.name).id(this.id).memberAddresses(this.memberAddresses).clientConfigType(this.clientConfigType).clientConfig(this.clientConfig).enabled(this.enabled);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String[] getMemberAddresses() {
        return this.memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClientConfigType getClientConfigType() {
        return this.clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getClientConfig() {
        return this.clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setMemberAddresses(String[] memberAddresses) {
        this.memberAddresses = memberAddresses;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfigType(ClientConfigType clientConfigType) {
        this.clientConfigType = clientConfigType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ClusterModel(name=" + this.getName() + ", id=" + this.getId() + ", memberAddresses=" + Arrays.deepToString(this.getMemberAddresses()) + ", clientConfigType=" + String.valueOf(this.getClientConfigType()) + ", clientConfig=" + this.getClientConfig() + ", enabled=" + this.isEnabled() + ")";
    }

    @ConstructorProperties(value={"name", "id", "memberAddresses", "clientConfigType", "clientConfig", "enabled"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ClusterModel(String name, String id, String[] memberAddresses, ClientConfigType clientConfigType, String clientConfig, boolean enabled) {
        this.name = name;
        this.id = id;
        this.memberAddresses = memberAddresses;
        this.clientConfigType = clientConfigType;
        this.clientConfig = clientConfig;
        this.enabled = enabled;
    }
}

