/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.model;

import java.util.Collection;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public final class LdapUser
implements LdapUserDetails {
    private final String dn;
    private final Collection<? extends GrantedAuthority> authorities;
    private String password;
    private final String username;
    private final boolean accountNonExpired;
    private final boolean accountNonLocked;
    private final boolean credentialsNonExpired;
    private final boolean enabled;

    private LdapUser(String dn, Collection<? extends GrantedAuthority> authorities, String password, String username, boolean accountNonExpired, boolean accountNonLocked, boolean credentialsNonExpired, boolean enabled) {
        this.dn = dn;
        this.authorities = authorities;
        this.password = password;
        this.username = username;
        this.accountNonExpired = accountNonExpired;
        this.accountNonLocked = accountNonLocked;
        this.credentialsNonExpired = credentialsNonExpired;
        this.enabled = enabled;
    }

    public static LdapUser create(LdapUserDetails ldapUserDetails, Collection<? extends GrantedAuthority> authorities) {
        return new LdapUser(ldapUserDetails.getDn(), authorities, ldapUserDetails.getPassword(), ldapUserDetails.getUsername(), ldapUserDetails.isAccountNonExpired(), ldapUserDetails.isAccountNonLocked(), ldapUserDetails.isCredentialsNonExpired(), ldapUserDetails.isEnabled());
    }

    public String getDn() {
        return this.dn;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void eraseCredentials() {
        this.password = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LdapUser ldapUser = (LdapUser)o;
        return Objects.equals(this.dn, ldapUser.dn);
    }

    public int hashCode() {
        return this.dn != null ? this.dn.hashCode() : 0;
    }

    public String toString() {
        return this.dn;
    }
}

