/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.ClosedStorageException;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.DataPointMemoryCompressionTracker;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteSeriesSerde;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteStartIdSerializer;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBLoader;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.StorageException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.TtlDB;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class RocksDBStore
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBStore.class);
    private static final boolean IS_COMPARE_EACH_PUT_ENABLED = System.getenv("MC_ROCKSDB_COMPARE_EACH_PUT") != null;
    static final String STORE_SUBDIR = "datapoints";
    private static final ThreadLocal<ByteBuffer> KEY_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(12).order(ByteOrder.BIG_ENDIAN));
    static final int VALUE_MAX_SIZE = 492;
    private static final ThreadLocal<ByteBuffer> VALUE_BUFFER = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(492).order(ByteOrder.BIG_ENDIAN));
    private final Path path;
    private final RocksDB store;
    private final ReadOptions readOptions;
    private final WriteOptions writeOptions;
    private final ReadWriteLock closeInProgressLock = new ReentrantReadWriteLock();
    private boolean closed;
    private final DataPointMemoryCompressionTracker dataPointMemoryCompressionTracker;

    RocksDBStore(Path dir, Duration ttl, DataPointMemoryCompressionTracker compressionTracker) {
        RocksDBLoader.loadLibrary();
        this.path = dir.resolve("datapoints");
        this.store = RocksDBStore.openOrCreateStore((Path)this.path, (Duration)ttl);
        this.readOptions = new ReadOptions();
        this.writeOptions = new WriteOptions();
        this.dataPointMemoryCompressionTracker = compressionTracker;
    }

    void putAll(List<MinuteBucket> buckets) {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            ByteBuffer keyBuffer = (ByteBuffer)KEY_BUFFER.get();
            ByteBuffer valueBuffer = (ByteBuffer)VALUE_BUFFER.get();
            try (WriteBatch batch = new WriteBatch();){
                for (MinuteBucket bucket : buckets) {
                    MinuteStartIdSerializer.serialize((MinuteStartId)bucket.minStartId(), (ByteBuffer)keyBuffer);
                    AtomicLongArray values = bucket.rawValues();
                    this.dataPointMemoryCompressionTracker.addInMemorySize((long)values.length() * 8L);
                    int serializedBytes = MinuteSeriesSerde.serialize((AtomicLongArray)values, (ByteBuffer)valueBuffer);
                    this.dataPointMemoryCompressionTracker.addOnDiskSize((long)serializedBytes);
                    batch.put(keyBuffer, valueBuffer);
                    if (!IS_COMPARE_EACH_PUT_ENABLED) continue;
                    long[] deserializedValues = MinuteSeriesSerde.deserialize((ByteBuffer)valueBuffer.position(0));
                    long[] inputValues = new long[values.length()];
                    for (int i = 0; i < values.length(); ++i) {
                        inputValues[i] = values.get(i);
                    }
                    if (Arrays.equals(inputValues, deserializedValues)) continue;
                    log.error("Deserialized values did not match expected values:\n    input:\n {}\n    input after serialization & deserialization:\n {}\n", (Object)Arrays.toString(inputValues), (Object)Arrays.toString(deserializedValues));
                }
                this.store.write(this.writeOptions, batch);
            }
            this.store.flushWal(true);
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    long[] get(MinuteStartId minStartId) {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            ByteBuffer keyBuffer = (ByteBuffer)KEY_BUFFER.get();
            ByteBuffer valueBuffer = ((ByteBuffer)VALUE_BUFFER.get()).clear();
            MinuteStartIdSerializer.serialize((MinuteStartId)minStartId, (ByteBuffer)keyBuffer);
            int result = this.store.get(this.readOptions, keyBuffer, valueBuffer);
            if (result == -1) {
                long[] lArray = null;
                return lArray;
            }
            long[] lArray = MinuteSeriesSerde.deserialize((ByteBuffer)valueBuffer);
            return lArray;
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    void compactRange() {
        this.closeInProgressLock.readLock().lock();
        try {
            this.ensureOpen();
            this.store.compactRange();
        }
        catch (RocksDBException e) {
            throw new StorageException.PersistenceException((Throwable)e);
        }
        finally {
            this.closeInProgressLock.readLock().unlock();
        }
    }

    @Override
    public void close() {
        this.closeInProgressLock.writeLock().lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.readOptions.close();
            this.writeOptions.close();
            this.store.closeE();
        }
        catch (Exception e) {
            log.warn("Could not close metrics store {}.", (Object)this.path, (Object)e);
        }
        finally {
            this.closeInProgressLock.writeLock().unlock();
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new ClosedStorageException();
        }
    }

    private static RocksDB openOrCreateStore(Path path, Duration ttl) {
        TtlDB ttlDB;
        block8: {
            Options options = new Options().setCreateIfMissing(true).setMaxLogFileSize(0x500000L).setKeepLogFileNum(10L).setPeriodicCompactionSeconds(ttl.getSeconds()).setWriteBufferSize(0x8000000L).setManualWalFlush(true);
            try {
                ttlDB = TtlDB.open((Options)options, (String)path.toAbsolutePath().toString(), (int)((int)ttl.getSeconds()), (boolean)false);
                if (options == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (options != null) {
                        try {
                            options.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new StorageException.PersistenceException("Failed to open metrics store " + String.valueOf(path) + " because it is corrupted. Please remove this file and restart the application.", (Throwable)e);
                }
            }
            options.close();
        }
        return ttlDB;
    }
}

