/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.controller.dto.metrics.storage.MetricsStorageDiagnosticsDTO;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBCompositeMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RocksDBMetricsStorageStatsSupplier
implements Supplier<MetricsStorageDiagnosticsDTO> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBMetricsStorageStatsSupplier.class);
    private final RocksDBCompositeMetricsStorage metricsStorage;
    private final RocksDBMetricsStorageStatsCounter statsCounter;
    private final Duration diskTtl;

    @Override
    public MetricsStorageDiagnosticsDTO get() {
        long persistedMinuteBucketsCount = this.metricsStorage.getPersistedMinuteBucketsCount();
        return MetricsStorageDiagnosticsDTO.builder().knownTimeSeries((long)this.metricsStorage.getMetricsRegistrySize()).trackedMinuteBuckets(this.metricsStorage.getTrackedMinuteBucketsCount()).persistenceRuns(this.statsCounter.persistenceRuns()).totalPersistenceRunTimeInMs(this.statsCounter.totalPersistenceRunTimeInMs()).maxPersistenceRunTimeInMs(this.statsCounter.maxPersistenceRunTimeInMs()).avgPersistenceRunTimeInMs(this.statsCounter.avgPersistenceRunTimeInMs()).lastHourAvgPersistenceRunTimeInMs(this.statsCounter.lastHourAvgPersistenceRunTimeInMs()).totalPersistedMinuteBuckets(persistedMinuteBucketsCount).maxPersistedMinuteBucketsPerRun(this.statsCounter.maxPersistedMinuteBucketsPerRun()).avgPersistedMinuteBucketsPerRun(this.statsCounter.avgPersistedMinuteBucketsPerRun(persistedMinuteBucketsCount)).lastHourAvgPersistedMinuteBucketsPerRun(this.statsCounter.lastHourAvgPersistedMinuteBucketsPerRun()).totalDroppedDataPoints(this.statsCounter.totalDroppedDataPoints()).totalEvictedDanglingMinuteSeries(this.statsCounter.totalEvictedDanglingMinuteSeries()).persistentStoreTTLSeconds(this.diskTtl.getSeconds()).storageSizeInBytes(this.metricsStorage.calculateDiskSize()).dataPointMemoryCompressionRatio(this.statsCounter.getDataPointMemoryCompressionTracker().ratio()).build();
    }

    @ConstructorProperties(value={"metricsStorage", "statsCounter", "diskTtl"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RocksDBMetricsStorageStatsSupplier(RocksDBCompositeMetricsStorage metricsStorage, RocksDBMetricsStorageStatsCounter statsCounter, Duration diskTtl) {
        this.metricsStorage = metricsStorage;
        this.statsCounter = statsCounter;
        this.diskTtl = diskTtl;
    }
}

