/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.impl.rocksdb;

import com.hazelcast.webmonitor.metrics.DataPointAware;
import com.hazelcast.webmonitor.metrics.DataPointSeries;
import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.MetricDataPoint;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.impl.AbstractMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.InMemoryCache;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteBucket;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteSeries;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.MinuteStartId;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.PersistentStoreManager;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RawDataPoint;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBCompositeMetricsStorage;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsRegistry;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBMetricsStorageStatsCounter;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBStore;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.RocksDBTimeUtil;
import com.hazelcast.webmonitor.metrics.impl.rocksdb.StorageException;
import com.hazelcast.webmonitor.metrics.utils.DataPointSeriesBuilder;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.utils.DirectorySizeCounter;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
class RocksDBCompositeMetricsStorage
extends AbstractMetricsStorage {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RocksDBCompositeMetricsStorage.class);
    private static final int INITIAL_IN_MEMORY_METRICS_CACHE_SIZE = 300000;
    static final String METRICS_SUBDIR = "metrics";
    private final RocksDBMetricsRegistry metricsRegistry;
    private final InMemoryCache inMemoryCache;
    private final int persistenceRunsInterval;
    private final PersistentStoreManager persistentStoreManager;
    private final ScheduledExecutorService persistenceRunsExecutor = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "MetricsPersistence"));
    private final RocksDBMetricsStorageStatsCounter statsCounter;
    private final Path metricsDir;

    RocksDBCompositeMetricsStorage(RocksDBMetricsStorageStatsCounter statsCounter, Clock clock, HomeDirectoryProvider homeDirectoryProvider, int persistenceRunsInterval, Duration accumulationPeriod, Duration persistentStoreTtl) {
        this.metricsDir = RocksDBCompositeMetricsStorage.createMetricsDir((HomeDirectoryProvider)homeDirectoryProvider);
        this.inMemoryCache = new InMemoryCache(statsCounter, 300000);
        this.statsCounter = statsCounter;
        this.persistenceRunsInterval = persistenceRunsInterval;
        this.metricsRegistry = new RocksDBMetricsRegistry(this.metricsDir);
        RocksDBStore store = new RocksDBStore(this.metricsDir, persistentStoreTtl, statsCounter.getDataPointMemoryCompressionTracker());
        this.persistentStoreManager = new PersistentStoreManager(clock, 300000, store, accumulationPeriod);
        this.persistenceRunsExecutor.scheduleAtFixedRate((Runnable)new PersistenceRunnable(this), this.persistenceRunsInterval, this.persistenceRunsInterval, TimeUnit.MILLISECONDS);
    }

    private static Path createMetricsDir(HomeDirectoryProvider homeDirectoryProvider) {
        Path dir = homeDirectoryProvider.get().resolve("metrics");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create directory " + String.valueOf(dir) + " for metrics storage", e);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doStore(@Nonnull String cluster, @Nonnull List<MetricDataPoint> dataPoints) {
        try {
            for (MetricDataPoint metricDataPoint : dataPoints) {
                MinuteSeries minuteSeries;
                if (!Metric.isPersistent((String)metricDataPoint.getName())) continue;
                int metricId = this.metricsRegistry.register(metricDataPoint.getMetric(), metricDataPoint.getTags());
                MinuteSeries minuteSeries2 = minuteSeries = this.inMemoryCache.getMinuteSeries(metricId);
                synchronized (minuteSeries2) {
                    MinuteBucket bucket = minuteSeries.put(metricId, metricDataPoint.getTime(), metricDataPoint.getValue());
                    if (bucket == null) {
                        this.statsCounter.incrementDroppedDataPoints();
                        continue;
                    }
                    this.persistentStoreManager.track(bucket);
                }
            }
            return;
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    protected DataPointSeries doQueryRange(@Nonnull Query query) {
        try {
            long[] minStarts;
            int metricId = this.metricsRegistry.get(query.getMetric(), (Map)query.getTags());
            if (metricId == -1) {
                return DataPointSeries.empty();
            }
            DataPointSeriesBuilder builder = new DataPointSeriesBuilder(query.getStart(), query.getEnd(), query.getMetric().getType());
            for (long minStart : minStarts = RocksDBTimeUtil.minuteStarts((long)query.getStart(), (long)query.getEnd())) {
                MinuteStartId minStartId = new MinuteStartId(metricId, minStart);
                long[] values = this.inMemoryCache.get(minStartId);
                if (values == null) {
                    values = this.persistentStoreManager.getPersistedValue(minStartId);
                }
                if (values == null) continue;
                long[] times = RocksDBTimeUtil.minuteTimePoints((long)minStart);
                builder.append(times, values);
            }
            return builder.build();
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    public Optional<DataPointAware> doQueryLatest(@Nonnull Query query) {
        try {
            long start = RocksDBTimeUtil.minuteStart((long)query.getStart());
            long ptr = RocksDBTimeUtil.minuteStart((long)query.getEnd());
            int metricId = this.metricsRegistry.get(query.getMetric(), (Map)query.getTags());
            if (metricId == -1) {
                return Optional.empty();
            }
            while (ptr >= start) {
                MinuteStartId minStartId = new MinuteStartId(metricId, ptr);
                RawDataPoint rawDataPoint = this.inMemoryCache.getLatest(minStartId, query.getEnd());
                if (rawDataPoint == null) {
                    rawDataPoint = this.persistentStoreManager.getLatestPersistedPoint(minStartId, query.getEnd());
                }
                if (rawDataPoint != null && rawDataPoint.time >= query.getStart()) {
                    return Optional.of(rawDataPoint.convert(query.getMetric().getType()));
                }
                ptr = RocksDBTimeUtil.prevMinuteStart((long)ptr);
            }
            return Optional.empty();
        }
        catch (StorageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StorageException.UnexpectedException((Throwable)e);
        }
    }

    protected Set<String> doGetMonitoredClusters() {
        throw new UnsupportedOperationException();
    }

    protected long doCountStoredDataPoints(@Nonnull String cluster) {
        throw new UnsupportedOperationException();
    }

    public void truncate(String cluster) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsTimeTravel() {
        return true;
    }

    public long calculateDiskSize() {
        return DirectorySizeCounter.countDiskSizeOf((Path)this.metricsDir);
    }

    protected void doClose() {
        try {
            ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.persistenceRunsExecutor);
            this.persistentStoreManager.persistAll();
        }
        catch (Exception e) {
            log.error("Could not close metrics storage.", (Throwable)e);
        }
        finally {
            this.metricsRegistry.close();
            this.persistentStoreManager.close();
            this.inMemoryCache.close();
        }
    }

    int getMetricsRegistrySize() {
        return this.metricsRegistry.size();
    }

    long getTrackedMinuteBucketsCount() {
        return this.persistentStoreManager.getTrackedSetSize();
    }

    long getPersistedMinuteBucketsCount() {
        return this.persistentStoreManager.getPersistedMinuteBucketsCount();
    }
}

