/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.TopicMetricsQueryFactory;
import com.hazelcast.webmonitor.model.InstanceType;
import java.util.EnumSet;

public final class TopicMetricsQueryFactory {
    private static final EnumSet<InstanceType> ALLOWED_TYPES = EnumSet.of(InstanceType.TOPIC, InstanceType.RELIABLE_TOPIC);
    private final Query.Builder queryBuilder;
    private final InstanceType instanceType;

    public TopicMetricsQueryFactory(Builder builder) {
        if (!ALLOWED_TYPES.contains(builder.instanceType)) {
            throw new IllegalArgumentException("TopicMetricsQueryFactory can be instantiated for " + String.valueOf(ALLOWED_TYPES));
        }
        this.instanceType = builder.instanceType;
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).addTag(Tag.NAME, builder.name).start(builder.start).end(builder.end);
    }

    public Query creationTimeQuery() {
        return this.queryBuilder.metric(Metric.forName((String)(this.dataStructure() + ".creationTime"))).build();
    }

    public Query totalPublishesQuery() {
        return this.queryBuilder.metric(Metric.forName((String)(this.dataStructure() + ".totalPublishes"))).build();
    }

    public Query totalReceivedMessagesQuery() {
        return this.queryBuilder.metric(Metric.forName((String)(this.dataStructure() + ".totalReceivedMessages"))).build();
    }

    private String dataStructure() {
        if (this.instanceType == InstanceType.TOPIC) {
            return "topic";
        }
        return "reliableTopic";
    }
}

