/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.metrics.imdg;

import com.hazelcast.webmonitor.metrics.Metric;
import com.hazelcast.webmonitor.metrics.Query;
import com.hazelcast.webmonitor.metrics.Tag;
import com.hazelcast.webmonitor.metrics.imdg.ExecutorMetricsQueryFactory;

public final class ExecutorMetricsQueryFactory {
    private final Query.Builder queryBuilder;

    public ExecutorMetricsQueryFactory(Builder builder) {
        this.queryBuilder = Query.builder().cluster(builder.cluster).member(builder.member).addTag(Tag.NAME, builder.name).start(builder.start).end(builder.end);
    }

    public Query creationTimeQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_CREATION_TIME).build();
    }

    public Query pendingTaskQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_PENDING).build();
    }

    public Query startedTaskQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_STARTED).build();
    }

    public Query completedTaskQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_COMPLETED).build();
    }

    public Query cancelledTaskQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_CANCELLED).build();
    }

    public Query totalExecutionTimeQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_TOTAL_EXECUTION_TIME).build();
    }

    public Query totalStartLatencyQuery() {
        return this.queryBuilder.metric(Metric.EXECUTOR_TOTAL_START_LATENCY).build();
    }
}

