/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.events;

import com.hazelcast.webmonitor.controller.dto.wan.WanEventsGroup;
import com.hazelcast.webmonitor.events.WanEventStore;
import com.hazelcast.webmonitor.events.model.AbstractEvent;
import com.hazelcast.webmonitor.events.model.AbstractWanEvent;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.wan.WanEventGroupFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class WanEventService {
    private static final Comparator<AbstractWanEvent> TIMESTAMP_COMPARATOR = Comparator.comparing(AbstractEvent::getTimestamp);
    private final WanEventStore eventStore;
    private final Function<Map<MemberIdentifier, AbstractWanEvent>, WanEventsGroup> eventFactory;

    @Autowired
    public WanEventService(WanEventStore eventStore) {
        this(eventStore, WanEventGroupFactory::create);
    }

    WanEventService(WanEventStore eventStore, Function<Map<MemberIdentifier, AbstractWanEvent>, WanEventsGroup> eventFactory) {
        this.eventStore = eventStore;
        this.eventFactory = eventFactory;
    }

    public List<WanEventsGroup> getGroupedWanSyncEvents(String cluster) {
        Map latestEventsPerMemberPerUuid = Arrays.stream(this.eventStore.getEventsForCluster(cluster)).collect(Collectors.groupingBy(AbstractWanEvent::getUuid, Collectors.toMap(AbstractEvent::memberIdent, Function.identity(), WanEventService.latestByTimestamp())));
        return latestEventsPerMemberPerUuid.values().stream().map(this.eventFactory).collect(Collectors.collectingAndThen(Collectors.toCollection(TreeSet::new), ArrayList::new));
    }

    private static BinaryOperator<AbstractWanEvent> latestByTimestamp() {
        return (a, b) -> TIMESTAMP_COMPARATOR.compare(a, b) > 0 ? a : b;
    }

    public List<AbstractWanEvent> getWanSyncEvents(String cluster, String uuid) {
        return Arrays.stream(this.eventStore.getEventsForCluster(cluster)).filter(event -> uuid.equals(event.getUuid())).collect(Collectors.toList());
    }
}

