/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.environment;

import com.hazelcast.webmonitor.EnvProperty;
import com.hazelcast.webmonitor.configreplacer.ConfigReplacerHelper;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLog;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

/*
 * Exception performing whole class analysis ignored.
 */
public class MCEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String MC_PROPERTY_SOURCE_NAME = "MC:prefixedAndReplaced";
    private static final DeferredLog LOG = new DeferredLog();

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        PropertySource systemEnv = environment.getPropertySources().get("systemEnvironment");
        PropertySource systemProps = environment.getPropertySources().get("systemProperties");
        assert (systemEnv != null);
        assert (systemProps != null);
        ConfigReplacerHelper.init();
        Map<String, Object> prefixedAndReplaced = Arrays.stream(EnvProperty.values()).map(it -> {
            String value = Optional.ofNullable(systemProps.getProperty(it.getSysPropName())).map(sysPropValue -> ConfigReplacerHelper.replace((String)it.getSysPropName(), (String)sysPropValue.toString())).orElseGet(() -> Optional.ofNullable(systemEnv.getProperty(it.getEnvVarName())).map(envVar -> ConfigReplacerHelper.replace((String)it.getEnvVarName(), (String)envVar.toString())).orElse(null));
            return Pair.of((Object)it.getSysPropName(), (Object)value);
        }).filter(it -> it.getValue() != null).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        MCEnvironmentPostProcessor.checkObsoleteInMemoryProperty(prefixedAndReplaced, (EnvProperty)EnvProperty.IN_MEMORY_STORE_MAX_SIZE);
        MCEnvironmentPostProcessor.checkObsoleteInMemoryProperty(prefixedAndReplaced, (EnvProperty)EnvProperty.IN_MEMORY_STORE_TTL_MINUTES);
        environment.getPropertySources().addBefore("systemProperties", (PropertySource)new MapPropertySource("MC:prefixedAndReplaced", prefixedAndReplaced));
        if (!environment.containsProperty("hazelcast.mc.jmx.ssl.enabled")) {
            prefixedAndReplaced.put("hazelcast.mc.jmx.ssl.enabled", environment.getProperty("hazelcast.mc.jmx.ssl"));
        }
        this.startActuatorOnlyIfHealthCheckIsEnabledOnSeparatePort(environment, prefixedAndReplaced);
        this.formatContextPath(environment, prefixedAndReplaced);
        prefixedAndReplaced.put("hazelcast.mc.metrics.storageImpl", MCEnvironmentPostProcessor.detectMetricsStorage((ConfigurableEnvironment)environment));
        if (Boolean.TRUE.equals(environment.getProperty("hazelcast.mc.internal.cloud", Boolean.class))) {
            environment.addActiveProfile("hzcloud");
        }
        application.addInitializers(new ApplicationContextInitializer[]{ctx -> LOG.replayTo(MCEnvironmentPostProcessor.class)});
    }

    private void formatContextPath(ConfigurableEnvironment environment, Map<String, Object> prefixedAndReplaced) {
        Object contextPath = environment.getProperty("hazelcast.mc.contextPath");
        String prefix = "/";
        if (contextPath != null) {
            if (!((String)contextPath).startsWith(prefix)) {
                contextPath = prefix + (String)contextPath;
            }
            if (((String)contextPath).endsWith(prefix)) {
                contextPath = ((String)contextPath).substring(0, ((String)contextPath).lastIndexOf(prefix));
            }
            prefixedAndReplaced.put("hazelcast.mc.contextPath", contextPath);
        } else {
            prefixedAndReplaced.put("hazelcast.mc.contextPath", prefix);
        }
    }

    private void startActuatorOnlyIfHealthCheckIsEnabledOnSeparatePort(ConfigurableEnvironment environment, Map<String, Object> prefixedAndReplaced) {
        int httpPort = (Integer)environment.getProperty("hazelcast.mc.http.port", Integer.class, (Object)8080);
        if (Boolean.TRUE.equals(environment.getProperty("hazelcast.mc.healthCheck.enable", Boolean.class))) {
            String healthCheckPort = environment.getProperty("hazelcast.mc.healthCheck.port");
            if (healthCheckPort == null) {
                prefixedAndReplaced.put("hazelcast.mc.healthCheck.port", httpPort + 1);
            }
        } else {
            prefixedAndReplaced.put("hazelcast.mc.healthCheck.port", -1);
        }
    }

    private static void checkObsoleteInMemoryProperty(Map<String, Object> map, EnvProperty property) {
        Object value = map.get(property.getSysPropName());
        if (value != null) {
            LOG.warn((Object)String.format("'%s' does not have effect anymore as there is no IN_MEMORY storage mode.", property));
        }
    }

    private static String detectMetricsStorage(ConfigurableEnvironment environment) {
        boolean metricsPersistenceEnabled;
        boolean bl = metricsPersistenceEnabled = (Boolean)environment.getProperty("hazelcast.mc.internal.cloud", Boolean.TYPE, (Object)false) == false && (Boolean)environment.getProperty("hazelcast.mc.metrics.persistence.enabled", Boolean.TYPE, (Object)true) != false;
        if (metricsPersistenceEnabled) {
            if (MCEnvironmentPostProcessor.isRocksDBSupportedOS((ConfigurableEnvironment)environment)) {
                return "RocksDB";
            }
            LOG.warn((Object)"Falling back to in-memory metrics storage.");
            return "In-memory";
        }
        return "In-memory";
    }

    private static boolean isRocksDBSupportedOS(ConfigurableEnvironment environment) {
        boolean result;
        PropertySource sysProps = environment.getPropertySources().get("systemProperties");
        assert (sysProps != null);
        String os = Optional.ofNullable(sysProps.getProperty("os.name")).map(Object::toString).orElse("");
        boolean bl = result = !StringUtils.equalsIgnoreCase((CharSequence)os, (CharSequence)"z/os");
        if (!result) {
            LOG.warn((Object)("RocksDB is not supported on " + os + " OS"));
        }
        return result;
    }
}

