/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.Config;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.QueueStoreConfig;
import com.hazelcast.version.Version;
import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.AddClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.BaseMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CacheDTO;
import com.hazelcast.webmonitor.controller.dto.ClusterDTO;
import com.hazelcast.webmonitor.controller.dto.ClusterMetadataDTO;
import com.hazelcast.webmonitor.controller.dto.ExecutorDTO;
import com.hazelcast.webmonitor.controller.dto.FlakeIdGeneratorDTO;
import com.hazelcast.webmonitor.controller.dto.HeapMemoryDistributionDTO;
import com.hazelcast.webmonitor.controller.dto.ListDTO;
import com.hazelcast.webmonitor.controller.dto.MemberDetailsDTO;
import com.hazelcast.webmonitor.controller.dto.MigrationStateDTO;
import com.hazelcast.webmonitor.controller.dto.MultiMapDTO;
import com.hazelcast.webmonitor.controller.dto.NoteDTO;
import com.hazelcast.webmonitor.controller.dto.PNCounterDTO;
import com.hazelcast.webmonitor.controller.dto.QueueDTO;
import com.hazelcast.webmonitor.controller.dto.ReliableTopicDTO;
import com.hazelcast.webmonitor.controller.dto.ReplicatedMapDTO;
import com.hazelcast.webmonitor.controller.dto.RollingUpgradeMetadataDTO;
import com.hazelcast.webmonitor.controller.dto.SetDTO;
import com.hazelcast.webmonitor.controller.dto.TopicDTO;
import com.hazelcast.webmonitor.controller.dto.UpdateClusterRequestDTO;
import com.hazelcast.webmonitor.controller.dto.VectorCollectionDTO;
import com.hazelcast.webmonitor.controller.dto.license.LicenseInfoDTO;
import com.hazelcast.webmonitor.controller.exception.InvalidClientConfigApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.model.InstanceType;
import com.hazelcast.webmonitor.model.hz.req.state.MemberState;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.ClusterStatsService;
import com.hazelcast.webmonitor.service.ListStatsService;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.service.SetStatsService;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfigService;
import com.hazelcast.webmonitor.utils.InternalObjectsUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.validation.Valid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.annotation.Secured;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(path={"/api"})
public class ClusterController
extends BaseInternalController {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterController.class);
    private final ClusterManager clusterManager;
    private final MemberManager memberManager;
    private final ClusterStatsService clusterStatsService;
    private final ListStatsService listStatsService;
    private final SetStatsService setStatsService;
    private final MemberConfigService memberConfigService;

    public ClusterController(StateManager stateManager, AuditLogService auditService, MemberManager memberManager, ClusterManager clusterManager, ClusterStatsService clusterStatsService, ListStatsService listStatsService, SetStatsService setStatsService, MemberConfigService memberConfigService) {
        super(stateManager, auditService);
        this.memberManager = memberManager;
        this.clusterManager = clusterManager;
        this.clusterStatsService = clusterStatsService;
        this.listStatsService = listStatsService;
        this.setStatsService = setStatsService;
        this.memberConfigService = memberConfigService;
    }

    @GetMapping(path={"/clusters"})
    public List<String> getClusters(@RequestParam(defaultValue="false") boolean connectedOnly) {
        return connectedOnly ? this.clusterManager.getConnectedClusterNames() : this.clusterManager.getAllClusterNames();
    }

    @GetMapping(value={"/clusters/{cluster}"})
    public ClusterDTO getCluster(@PathVariable String cluster) {
        return ClusterDTO.fromModel((ClusterModel)this.clusterManager.getCluster(cluster));
    }

    @GetMapping(value={"/clusters/version"})
    public Map<String, String> getConnectedClusterVersions() {
        return this.clusterManager.getConnectedClusterVersions();
    }

    @PostMapping(value={"/clusters/{cluster}/detectVersionMismatch"})
    public void runVersionMismatchDetection(@PathVariable String cluster) {
        this.clusterManager.runVersionMismatchDetection(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/license"})
    public LicenseInfoDTO getClusterLicense(@PathVariable String cluster) {
        return this.clusterManager.getClusterLicense(cluster).map(LicenseInfoDTO::clusterLicense).orElseGet(LicenseInfoDTO::notConfigured);
    }

    @GetMapping(value={"/clusters/{cluster}/anyNotifications"})
    public List<NoteDTO> anyNotifications(@PathVariable String cluster) {
        return this.clusterManager.anyNotifications(cluster).map(note -> NoteDTO.builder().cluster(note.cluster).matter(note.matter).message(note.message).title(note.title).severity(note.severity).ttl(note.ttl).build()).collect(Collectors.toList());
    }

    @PostMapping(path={"/clusters"}, params={"clientConfigType"})
    @Secured(value={"ROLE_ADMIN"})
    public void addCluster(@RequestParam ClusterDTO.ClientConfigType clientConfigType, @RequestParam MultipartFile clientConfig, @RequestParam boolean enabled) throws IOException {
        byte[] configFileContent = clientConfig.getBytes();
        try {
            this.clusterManager.add(clientConfigType.toModel(), configFileContent, enabled);
        }
        catch (InvalidConfigurationException e) {
            log.info("Invalid client config provided.", (Throwable)e);
            throw new InvalidClientConfigApiException(e.getMessage());
        }
    }

    @PostMapping(value={"/clusters"})
    @Secured(value={"ROLE_ADMIN"})
    public void addCluster(@Valid @RequestBody AddClusterRequestDTO dto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clusterManager.add(dto);
    }

    @PostMapping(path={"/clusters/{cluster}"}, params={"clientConfigType"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateCluster(@PathVariable String cluster, @RequestParam ClusterDTO.ClientConfigType clientConfigType, @RequestParam MultipartFile clientConfig, @RequestParam boolean enabled) throws IOException {
        byte[] configFileContent = clientConfig.getBytes();
        try {
            this.clusterManager.update(cluster, clientConfigType.toModel(), configFileContent, enabled);
        }
        catch (InvalidConfigurationException e) {
            log.info("Invalid client config provided for cluster {}.", (Object)cluster, (Object)e);
            throw new InvalidClientConfigApiException();
        }
    }

    @PostMapping(path={"/clusters/{cluster}"})
    @Secured(value={"ROLE_ADMIN"})
    public void updateCluster(@PathVariable String cluster, @Valid @RequestBody UpdateClusterRequestDTO dto, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.clusterManager.update(cluster, dto);
    }

    @DeleteMapping(value={"/clusters/{cluster}"})
    @Secured(value={"ROLE_ADMIN"})
    public void removeCluster(@PathVariable String cluster) {
        this.clusterManager.remove(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/migrationStatus"})
    public MigrationStateDTO getClusterMigrationState(@PathVariable String cluster) {
        return this.clusterStatsService.getClusterMigrationState(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/metadata"})
    public ClusterMetadataDTO getClusterMetadata(@PathVariable String cluster) {
        this.clusterManager.verifyClusterConnected(cluster);
        return new ClusterMetadataDTO(this.stateManager.getClusterState(cluster), this.clusterManager.getJetStatus(cluster));
    }

    @PostMapping(path={"/clusters/{cluster}/state"})
    @Secured(value={"ROLE_ADMIN"})
    public void changeClusterState(@PathVariable String cluster, @RequestParam ClusterState newState) {
        this.executeOperation(() -> this.clusterManager.changeState(cluster, newState), this.operationLogBuilder("MC-1003 [Cluster Config]", "Change Cluster State").parameter("cluster", (Object)cluster).parameter("newState", (Object)newState));
    }

    @PostMapping(path={"/clusters/{cluster}/shutdown"})
    @Secured(value={"ROLE_ADMIN"})
    public void shutdown(@PathVariable String cluster) {
        this.executeOperation(() -> this.clusterManager.shutdown(cluster), this.operationLogBuilder("MC-1004 [Cluster Config]", "Shutdown Cluster").parameter("cluster", (Object)cluster));
    }

    @GetMapping(path={"/clusters/{cluster}/rollingUpgradeMetadata"})
    public RollingUpgradeMetadataDTO rollingUpgradeMetadata(@PathVariable String cluster) {
        String currentVersion = this.clusterManager.clusterVersion(cluster);
        Version nextVersion = this.clusterManager.rollingUpgradeNextVersion(cluster);
        List members = this.memberManager.getMembers(cluster, 0L, 0L);
        boolean isRollingUpgradePossible = members.stream().map(member -> Version.of((String)member.getVersion())).allMatch(version -> version.isGreaterOrEqual(nextVersion));
        String upgradeImpossibilityReason = isRollingUpgradePossible ? "" : String.format("Some cluster members do not have correct version. All members should have version %s.", nextVersion);
        return new RollingUpgradeMetadataDTO(currentVersion, nextVersion.toString(), isRollingUpgradePossible, upgradeImpossibilityReason);
    }

    @PostMapping(path={"/clusters/{cluster}/changeVersion"})
    @Secured(value={"ROLE_ADMIN"})
    public String changeClusterVersion(@PathVariable String cluster) {
        Version targetVersion = this.clusterManager.rollingUpgradeNextVersion(cluster);
        if (targetVersion == null) {
            throw new NoClusterApiException(cluster);
        }
        this.executeOperation(() -> this.clusterManager.changeVersion(cluster, targetVersion), this.operationLogBuilder("MC-1007 [Cluster Config]", "Change Cluster Version").parameter("cluster", (Object)cluster).parameter("version", (Object)targetVersion));
        return targetVersion.toString();
    }

    @GetMapping(path={"/clusters/{cluster}/lists"})
    public List<ListDTO> getLists(@PathVariable String cluster) {
        return this.listStatsService.getClusterLists(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/sets"})
    public List<SetDTO> getSets(@PathVariable String cluster) {
        return this.setStatsService.getClusterSets(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/caches"})
    public List<CacheDTO> getCaches(@PathVariable String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.memberConfigService.getRandomConfigFromCluster(cluster).map(rawConfig -> {
            Config config = rawConfig.toEffectiveConfig();
            return state.getInstanceNames(InstanceType.CACHE).stream().map(name -> new CacheDTO(name, config.findCacheConfig(name).getDataPersistenceConfig().isEnabled())).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    @GetMapping(path={"/clusters/{cluster}/multiMaps"})
    public List<MultiMapDTO> getMultiMaps(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.MULTIMAP, cluster).stream().map(MultiMapDTO::new).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/replicatedMaps"})
    public List<ReplicatedMapDTO> getReplicatedMaps(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.REPLICATED_MAP, cluster).stream().map(ReplicatedMapDTO::new).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/topics"})
    public List<TopicDTO> getTopics(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.TOPIC, cluster).stream().map(TopicDTO::new).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/reliableTopics"})
    public List<ReliableTopicDTO> getReliableTopics(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.RELIABLE_TOPIC, cluster).stream().map(ReliableTopicDTO::new).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/queues"})
    public List<QueueDTO> getQueues(@PathVariable String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        return this.memberConfigService.getRandomConfigFromCluster(cluster).map(rawConfig -> {
            Config config = rawConfig.toEffectiveConfig();
            return state.getInstanceNames(InstanceType.QUEUE).stream().map(name -> {
                QueueStoreConfig queueStoreConfig = config.findQueueConfig(name).getQueueStoreConfig();
                return new QueueDTO(name, queueStoreConfig != null && queueStoreConfig.isEnabled());
            }).collect(Collectors.toList());
        }).orElse(Collections.emptyList());
    }

    @GetMapping(path={"/clusters/{cluster}/executors"})
    public List<ExecutorDTO> getExecutors(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.EXECUTOR_SERVICE, cluster).stream().map(ExecutorDTO::new).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/memberDetails"})
    public List<MemberDetailsDTO> getMemberStats(@PathVariable String cluster) {
        return this.memberManager.getMembers(cluster, 0L, 0L);
    }

    @GetMapping(path={"/clusters/{cluster}/members"})
    public List<BaseMemberDTO> getMemberStats(@PathVariable String cluster, @RequestParam(defaultValue="0") long time, @RequestParam(defaultValue="0") long interval) {
        return this.toBaseMemberDTO(this.memberManager.getMembers(cluster, time, interval));
    }

    private List<BaseMemberDTO> toBaseMemberDTO(List<MemberDetailsDTO> members) {
        return members.stream().map(member -> new BaseMemberDTO(member.getAddress(), member.isLite())).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/counters"})
    public List<PNCounterDTO> getPNCounters(@PathVariable String cluster) {
        AllState state = this.stateManager.getLatestState(cluster);
        if (state == null) {
            return Collections.emptyList();
        }
        SortedSet counters = state.getInstanceNames(InstanceType.COUNTER);
        ArrayList<PNCounterDTO> result = new ArrayList<PNCounterDTO>(counters.size());
        for (String counter : counters) {
            int members = 0;
            for (MemberState memberState : state.getMemberStates()) {
                if (!memberState.hasLocalInstanceStats(InstanceType.COUNTER, counter)) continue;
                ++members;
            }
            result.add(new PNCounterDTO(counter, members));
        }
        return result;
    }

    @GetMapping(path={"/clusters/{cluster}/flakeIds"})
    public List<FlakeIdGeneratorDTO> getFlakeIdGenerators(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.FLAKE_ID_GENERATOR, cluster).stream().map(flakeId -> new FlakeIdGeneratorDTO(flakeId, InternalObjectsUtil.isInternalObject((String)flakeId))).collect(Collectors.toList());
    }

    @GetMapping(path={"/clusters/{cluster}/memoryDistribution"})
    public HeapMemoryDistributionDTO getMemoryDistribution(@PathVariable String cluster) {
        return this.clusterStatsService.getHeapMemoryDistribution(cluster);
    }

    @GetMapping(path={"/clusters/{cluster}/vectorcollections"})
    public List<VectorCollectionDTO> vectorCollections(@PathVariable String cluster) {
        return this.stateManager.getInstanceNames(InstanceType.VECTOR_COLLECTION, cluster).stream().map(VectorCollectionDTO::new).toList();
    }
}

