/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemMemberDTO;
import com.hazelcast.webmonitor.controller.dto.CPSubsystemStatusDTO;
import com.hazelcast.webmonitor.controller.dto.cp.AtomicLongStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.AtomicRefStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPGroupMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPMapStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSessionMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CPSubsystemMetricsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.CountDownLatchStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.FencedLockStatsDTO;
import com.hazelcast.webmonitor.controller.dto.cp.SemaphoreStatsDTO;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.service.CPStatsRegistry;
import com.hazelcast.webmonitor.service.CPSubsystemManager;
import com.hazelcast.webmonitor.service.StateManager;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/clusters/{cluster}/cpSubsystem"})
public class CPSubsystemController
extends BaseInternalController {
    private final CPSubsystemManager cpSubsystemManager;
    private final CPStatsRegistry cpStatsRegistry;

    @Autowired
    public CPSubsystemController(CPSubsystemManager cpSubsystemManager, StateManager stateManager, CPStatsRegistry cpStatsRegistry, AuditLogService auditService) {
        super(stateManager, auditService);
        this.cpSubsystemManager = cpSubsystemManager;
        this.cpStatsRegistry = cpStatsRegistry;
    }

    @GetMapping(path={"/status"})
    public CPSubsystemStatusDTO getStatus(@PathVariable String cluster) {
        return this.cpSubsystemManager.getStatus(cluster);
    }

    @GetMapping(path={"/members"})
    public List<CPSubsystemMemberDTO> getCPMembers(@PathVariable String cluster) {
        return this.cpSubsystemManager.getCPMembers(cluster);
    }

    @PostMapping(path={"/promote"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void promoteToCPMember(@PathVariable String cluster, @RequestParam String member) {
        this.executeOperation(() -> this.cpSubsystemManager.promoteToCPMember(cluster, member), this.operationLogBuilder("MC-8001 [CP Subsystem]", "Promote Member to CP Subsystem").parameter("cluster", (Object)cluster).parameter("member", (Object)member));
    }

    @PostMapping(path={"/remove"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void removeCPMember(@PathVariable String cluster, @RequestParam UUID cpMemberUuid) {
        this.executeOperation(() -> this.cpSubsystemManager.removeCPMember(cluster, cpMemberUuid), this.operationLogBuilder("MC-8002 [CP Subsystem]", "Remove CP Member from CP Subsystem").parameter("cluster", (Object)cluster).parameter("cpMemberUuid", (Object)cpMemberUuid));
    }

    @PostMapping(path={"/reset"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_CLOUD_USER"})
    public void reset(@PathVariable String cluster) {
        this.executeOperation(() -> this.cpSubsystemManager.resetCPSubsystem(cluster), this.operationLogBuilder("MC-8003 [CP Subsystem]", "Restart CP Subsystem").parameter("cluster", (Object)cluster));
    }

    @DeleteMapping(path={"/groups/{groupName}/sessions/{sessionId}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public void terminateCPSession(@PathVariable String cluster, @PathVariable long sessionId, @PathVariable String groupName) {
        this.executeOperation(() -> this.cpSubsystemManager.terminateCPSession(cluster, groupName, sessionId), this.operationLogBuilder("MC-8004 [CP Subsystem]", "Close CP Session").parameter("cluster", (Object)cluster).parameter("groupName", (Object)groupName).parameter("sessionId", (Object)sessionId));
    }

    @GetMapping(path={"/metrics/subsystem"})
    public Collection<CPSubsystemMetricsDTO> subsystemMetrics(@PathVariable String cluster) {
        return this.cpSubsystemManager.getSubsystemMetrics(cluster);
    }

    @GetMapping(path={"/metrics/groups"})
    public Collection<CPGroupMetricsDTO> groupMetrics(@PathVariable String cluster) {
        return this.cpSubsystemManager.getGroupMetrics(cluster);
    }

    @GetMapping(path={"/metrics/session"})
    public Collection<CPSessionMetricsDTO> sessionMetrics(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownSessions(cluster).values();
    }

    @GetMapping(path={"/atomiclongs"})
    public Collection<AtomicLongStatsDTO> atomicLongs(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownAtomicLongs(cluster).values();
    }

    @GetMapping(path={"/semaphores"})
    public Collection<SemaphoreStatsDTO> semaphores(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownSemaphores(cluster).values();
    }

    @GetMapping(path={"/cpMaps"})
    public Collection<CPMapStatsDTO> cpMaps(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownCPMaps(cluster).values();
    }

    @GetMapping(path={"/atomicreferences"})
    public Collection<AtomicRefStatsDTO> atomicReferences(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownAtomicRefs(cluster).values();
    }

    @GetMapping(path={"/fencedlocks"})
    public Collection<FencedLockStatsDTO> fencedLocks(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownFencedLocks(cluster).values();
    }

    @GetMapping(path={"/countdownlatches"})
    public Collection<CountDownLatchStatsDTO> countdownLatches(@PathVariable String cluster) {
        return this.cpStatsRegistry.getKnownCountdownLatches(cluster).values();
    }
}

