/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.internal;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.controller.dto.security.AuthTokenDTO;
import com.hazelcast.webmonitor.controller.dto.security.IssueAuthTokenDTO;
import com.hazelcast.webmonitor.controller.dto.security.IssuedAuthTokenDTO;
import com.hazelcast.webmonitor.controller.dto.security.RevokeAuthTokenDTO;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.controller.exception.NoUserFoundApiException;
import com.hazelcast.webmonitor.controller.exception.RestApiTokenLabelAlreadyExistsException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.controller.internal.BaseInternalController;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.service.StateManager;
import com.hazelcast.webmonitor.utils.SecurityContextUtil;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.context.annotation.Profile;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api"})
@Profile(value={"!hzcloud"})
public class AuthTokenController
extends BaseInternalController {
    private final AuthTokenManager authTokenManager;
    private final AuthenticationManagerImpl authenticationManager;

    public AuthTokenController(StateManager stateManager, AuditLogService auditService, AuthTokenManager authTokenManager, AuthenticationManagerImpl authenticationManager) {
        super(stateManager, auditService);
        this.authTokenManager = authTokenManager;
        this.authenticationManager = authenticationManager;
    }

    @GetMapping(path={"/tokens"})
    @Secured(value={"ROLE_ADMIN"})
    public List<AuthTokenDTO> listAllTokens() {
        String username = SecurityContextUtil.getUsername();
        this.verifySufficientPermissions(username);
        return this.authTokenManager.findAllTokens();
    }

    @PostMapping(path={"/tokens"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_METRICS_ONLY"})
    public IssuedAuthTokenDTO issue(@Valid @RequestBody IssueAuthTokenDTO inputDTO, BindingResult bindingResult) {
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        this.verifySufficientPermissions(inputDTO.getUsername());
        this.verifyUserExists(inputDTO.getUsername());
        this.verifyCanGetUserAuthorities(inputDTO.getUsername());
        this.verifyTokenLabelNotExistsForUser(inputDTO.getUsername(), inputDTO.getLabel());
        IssuedAuthTokenDTO issuedToken = this.authTokenManager.issue(inputDTO.getUsername(), inputDTO.getLabel(), this.getAuthorities());
        this.auditService.log(this.logBuilder("MC-2004 [Auth]", "Issued auth token for user").parameter("targetUser", (Object)issuedToken.getUsername()).parameter("label", (Object)issuedToken.getLabel()).build());
        return issuedToken;
    }

    @DeleteMapping(path={"/tokens"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_METRICS_ONLY"})
    public void revoke(@Valid @RequestBody RevokeAuthTokenDTO inputDTO, BindingResult bindingResult) {
        boolean revoked;
        String message;
        ValidationFailedApiException.processValidationResult((BindingResult)bindingResult);
        String username = this.extractUsername(inputDTO);
        if (username == null) {
            return;
        }
        this.verifySufficientPermissions(username);
        if (inputDTO.getTokenId() != null) {
            this.verifyTokenExists(inputDTO.getTokenId());
            message = "Revoked a single auth token for user";
            revoked = this.authTokenManager.revokeByTokenId(inputDTO.getTokenId());
        } else {
            message = "Revoked all auth tokens for user";
            boolean bl = revoked = this.authTokenManager.revokeAll(inputDTO.getUsername()) > 0;
        }
        if (revoked) {
            this.auditService.log(this.logBuilder("MC-2005 [Auth]", message).parameter("targetUser", (Object)username).build());
        }
    }

    @GetMapping(path={"tokens/{username}"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_READONLY_USER", "ROLE_METRICS_ONLY"})
    public List<AuthTokenDTO> listTokens(@PathVariable String username) {
        this.verifySufficientPermissions(username);
        this.verifyUserExists(username);
        return this.authTokenManager.findAllForUser(username);
    }

    private boolean isAdminRequest() {
        return SecurityContextUtil.getAuthorities().stream().map(GrantedAuthority::getAuthority).anyMatch("ROLE_ADMIN"::equals);
    }

    private String extractUsername(RevokeAuthTokenDTO inputDTO) {
        if (inputDTO.getTokenId() != null) {
            Optional optAuthToken = this.authTokenManager.findById(inputDTO.getTokenId());
            return optAuthToken.map(AuthTokenDTO::getUsername).orElse(null);
        }
        return inputDTO.getUsername();
    }

    private Collection<? extends GrantedAuthority> getAuthorities() {
        if (!this.authenticationManager.isUserManagementSupported()) {
            return SecurityContextUtil.getAuthorities();
        }
        return null;
    }

    private void verifySufficientPermissions(String username) {
        if (this.isTokenForAnotherUser(username) && !this.isAdminRequest()) {
            throw new AccessDeniedException("Only admin user can create a token for another user");
        }
    }

    private void verifyUserExists(String username) {
        try {
            if (this.authenticationManager.isUserManagementSupported()) {
                this.authenticationManager.getUser(username);
            }
        }
        catch (NoUserFoundApiException e) {
            throw new NoResourceApiException("User with username [" + username + "]");
        }
    }

    private void verifyTokenExists(String tokenId) {
        if (this.authTokenManager.findById(tokenId).isEmpty()) {
            throw new NoResourceApiException("Token with id " + tokenId);
        }
    }

    private void verifyTokenLabelNotExistsForUser(String username, String label) {
        if (this.authTokenManager.findByLabelForUser(username, label).isPresent()) {
            throw new RestApiTokenLabelAlreadyExistsException("Token with label " + label + " is already exists for user [" + username + "]");
        }
    }

    private void verifyCanGetUserAuthorities(String username) {
        if (this.isTokenForAnotherUser(username) && !this.authenticationManager.isUserManagementSupported()) {
            throw new ValidationFailedApiException("User can create a token for another user only if Default security provider is used.");
        }
    }

    private boolean isTokenForAnotherUser(String username) {
        return !Objects.equals(username, SecurityContextUtil.getUsername());
    }
}

