/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.controller.exception;

import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.webmonitor.controller.dto.ApiErrorDTO;
import com.hazelcast.webmonitor.controller.exception.ApiException;
import com.hazelcast.webmonitor.controller.exception.LicenseAlreadyConfiguredException;
import com.hazelcast.webmonitor.controller.exception.NoClientApiException;
import com.hazelcast.webmonitor.controller.exception.NoClusterApiException;
import com.hazelcast.webmonitor.controller.exception.NoDataStructureApiException;
import com.hazelcast.webmonitor.controller.exception.NoMasterMemberApiException;
import com.hazelcast.webmonitor.controller.exception.NoMemberApiException;
import com.hazelcast.webmonitor.controller.exception.NoResourceApiException;
import com.hazelcast.webmonitor.controller.exception.RestApiTokenLabelAlreadyExistsException;
import com.hazelcast.webmonitor.controller.exception.ValidationFailedApiException;
import com.hazelcast.webmonitor.sql.ConnectorNotFoundException;
import org.jdbi.v3.core.statement.StatementException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.web.server.csrf.CsrfException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class ApiExceptionHandler
extends ResponseEntityExceptionHandler {
    @ExceptionHandler
    public ResponseEntity<ApiErrorDTO> handleApiException(ApiException e) {
        this.logger.debug((Object)e.getMessage(), (Throwable)e);
        return ResponseEntity.ok((Object)new ApiErrorDTO(e));
    }

    @ExceptionHandler(value={InvalidLicenseException.class})
    public ResponseEntity<ApiErrorDTO> handleInvalidLicenseException(InvalidLicenseException e) {
        this.logger.warn((Object)"The feature you are trying to reach requires valid license. Please contact sales@hazelcast.com");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.PAYMENT_REQUIRED).body((Object)new ApiErrorDTO("LICENSE_REQUIRED", e.getMessage()));
    }

    @ExceptionHandler(value={LicenseAlreadyConfiguredException.class})
    public ResponseEntity<ApiErrorDTO> handleLicenseAlreadyConfiguredException(LicenseAlreadyConfiguredException e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ApiErrorDTO(e.getType(), e.getMessage()));
    }

    @ExceptionHandler(value={NoClusterApiException.class, NoMemberApiException.class, NoMasterMemberApiException.class, NoClientApiException.class, NoDataStructureApiException.class, NoResourceApiException.class, ConnectorNotFoundException.class})
    public ResponseEntity<ApiErrorDTO> handleMissingDataExceptions(ApiException e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)new ApiErrorDTO(e));
    }

    @ExceptionHandler(value={RestApiTokenLabelAlreadyExistsException.class})
    public ResponseEntity<ApiErrorDTO> handleRestApiTokenLabelAlreadyExistsException(RestApiTokenLabelAlreadyExistsException e) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)new ApiErrorDTO(e.getType(), e.getMessage()));
    }

    @ExceptionHandler
    public ResponseEntity<ApiErrorDTO> handleValidationException(ValidationFailedApiException e) {
        return ResponseEntity.badRequest().body((Object)new ApiErrorDTO((ApiException)e));
    }

    @ExceptionHandler(value={StatementException.class})
    public ResponseEntity<ApiErrorDTO> handleJdbiStatementExceptions() {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)new ApiErrorDTO("BAD_REQUEST", "An error occurred while executing SQL statement"));
    }

    @ExceptionHandler
    public ResponseEntity<ApiErrorDTO> handleException(Exception e) {
        if (this.isInsufficientRoleException(e)) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)new ApiErrorDTO("FORBIDDEN", "Insufficient role."));
        }
        this.logger.error((Object)e.getMessage(), (Throwable)e);
        return ResponseEntity.internalServerError().body((Object)new ApiErrorDTO("GENERAL_EXCEPTION", String.format("An exception occurred: %s", e.getMessage())));
    }

    protected ResponseEntity<Object> handleMissingPathVariable(MissingPathVariableException e, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.badRequestResponse((Exception)e);
    }

    protected ResponseEntity<Object> handleMissingServletRequestParameter(MissingServletRequestParameterException e, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.badRequestResponse((Exception)e);
    }

    protected ResponseEntity<Object> handleHttpMessageNotReadable(HttpMessageNotReadableException e, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.badRequestResponse((Exception)e);
    }

    protected ResponseEntity<Object> handleTypeMismatch(TypeMismatchException e, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        return this.badRequestResponse((Exception)e);
    }

    private ResponseEntity<Object> badRequestResponse(Exception e) {
        return ResponseEntity.badRequest().body((Object)new ApiErrorDTO("BAD_REQUEST", e.getMessage()));
    }

    private boolean isInsufficientRoleException(Exception e) {
        return e instanceof AccessDeniedException && !(e instanceof AuthorizationServiceException) && !(e instanceof org.springframework.security.web.csrf.CsrfException) && !(e instanceof CsrfException);
    }
}

