/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.console;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigXmlGenerator;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.console.Console;
import com.hazelcast.webmonitor.console.ConsoleRequestProcessor;
import com.hazelcast.webmonitor.console.dto.ConsoleLaunchDTO;
import com.hazelcast.webmonitor.model.sql.ClusterModel;
import com.hazelcast.webmonitor.service.ClientConfigSanitizer;
import com.hazelcast.webmonitor.service.ClusterManager;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.MemberManager;
import com.hazelcast.webmonitor.utils.ExtractUtil;
import com.hazelcast.webmonitor.utils.FileSystemUtil;
import com.hazelcast.webmonitor.utils.PlatformUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ConsoleManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsoleManager.class);
    public static final String SOURCE_CLIENT_CONFIG_XML_NAME = "source-client-config.xml";
    protected static final String CONSOLE_HOME = "clc";
    private static final String CLC_VERSION = "MC-v" + BuildInfo.getConsoleVersion();
    private static final Set<Pair<PlatformUtil.OS, PlatformUtil.Arch>> SUPPORTED_PLATFORMS = Set.of(Pair.of((Object)PlatformUtil.OS.UNIX, (Object)PlatformUtil.Arch.ARM64), Pair.of((Object)PlatformUtil.OS.UNIX, (Object)PlatformUtil.Arch.ARM), Pair.of((Object)PlatformUtil.OS.UNIX, (Object)PlatformUtil.Arch.AMD64), Pair.of((Object)PlatformUtil.OS.MACOS, (Object)PlatformUtil.Arch.ARM64), Pair.of((Object)PlatformUtil.OS.MACOS, (Object)PlatformUtil.Arch.AMD64), Pair.of((Object)PlatformUtil.OS.WINDOWS, (Object)PlatformUtil.Arch.AMD64));
    private static final String CONSOLE_RESOURCES_FOLDER = "console";
    private static final Map<String, Set<PosixFilePermission>> CONSOLE_FILE_PERMISSIONS = Map.of("shell.clc", ExtractUtil.RW_PERMISSION, ConsoleManager.getClcExecutableName(), ExtractUtil.ALL_GRANTED_PERMISSION);
    private final ConsoleRequestProcessor consoleRequestProcessor;
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final ClusterManager clusterManager;
    private final MemberManager memberManager;
    private final MCConfigurationProperties mcConfigurationProperties;
    private final ClientConfigSanitizer clientConfigSanitizer;

    public ConsoleLaunchDTO start(String cluster, String username) {
        if (!this.isCLCSupportedOS()) {
            return ConsoleLaunchDTO.unsupportedOsError();
        }
        if (!this.isCLCSupportedTLSConfig(cluster)) {
            return ConsoleLaunchDTO.unsupportedTlsError();
        }
        if (!this.extractCLCBinary()) {
            return ConsoleLaunchDTO.extractionError();
        }
        if (!this.createConsoleConfig(cluster)) {
            return this.consoleXmlConfigError(cluster);
        }
        return this.launchInteractiveConsole(cluster, username).map(ConsoleLaunchDTO::success).orElseGet(ConsoleLaunchDTO::launchError);
    }

    private ConsoleLaunchDTO consoleXmlConfigError(String clusterName) {
        ClusterModel cluster = this.clusterManager.getCluster(clusterName);
        Path configDirectory = this.resolveConfigDirectory(cluster);
        ConsoleLaunchDTO error = ConsoleLaunchDTO.configGenerationError((String)configDirectory.resolve("source-client-config.xml").toString());
        log.error(error.getDetails());
        return error;
    }

    public void pipe(String consoleUuid, String input) {
        if (StringUtils.isNotEmpty((CharSequence)input)) {
            this.consoleRequestProcessor.pipe(consoleUuid, input);
        }
    }

    public static boolean removeConsoleConfig(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try {
                FileSystemUtil.deleteDirectoryRecursively((Path)path);
            }
            catch (IOException e) {
                log.warn("Failed to delete console configuration folder.");
                return false;
            }
        }
        return true;
    }

    Optional<String> launchInteractiveConsole(String clusterName, String username) {
        Path binary = this.getCLCExecutablePath();
        if (Files.isExecutable(binary) && Files.exists(binary, new LinkOption[0])) {
            ClusterModel cluster = this.clusterManager.getCluster(clusterName);
            String home = this.homeDirectoryProvider.get().resolve("clc").toAbsolutePath().toString();
            Console console = new Console(cluster.getId(), home, binary.toAbsolutePath().toString(), true, this.mcConfigurationProperties.getClcCommandTimeoutSeconds());
            if (console.start()) {
                this.consoleRequestProcessor.addConsoleInstance(username, console);
                return Optional.of(console.getUuid());
            }
        }
        return Optional.empty();
    }

    int launchNoninteractiveConsole(String clusterName, String command) {
        Path binary = this.getCLCExecutablePath();
        if (Files.isExecutable(binary) && Files.exists(binary, new LinkOption[0])) {
            ClusterModel cluster = this.clusterManager.getCluster(clusterName);
            String home = this.homeDirectoryProvider.get().resolve("clc").toAbsolutePath().toString();
            Console console = new Console(cluster.getId(), home, String.valueOf(binary.toAbsolutePath()) + " " + command, false, this.mcConfigurationProperties.getClcCommandTimeoutSeconds());
            if (console.start()) {
                console.waitFor();
                console.destroy();
                return console.getProcess().exitValue();
            }
        }
        return -1;
    }

    boolean extractCLCBinary() {
        this.createCLCHome();
        String name = this.getCLCZipName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        Path binary = this.getCLCExecutablePath();
        if (!Files.exists(binary, new LinkOption[0])) {
            boolean bl;
            block10: {
                this.cleanupOldCLCFilesIfExists();
                String path = "console/" + name;
                InputStream file = ConsoleManager.class.getClassLoader().getResourceAsStream(path);
                try {
                    boolean bl2 = bl = file != null && ExtractUtil.unzip((InputStream)file, (Path)this.homeDirectoryProvider.get().resolve("clc").toAbsolutePath(), (Map)CONSOLE_FILE_PERMISSIONS);
                    if (file == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn("Failed to extract console binary from {}", (Object)path, (Object)e);
                        return false;
                    }
                }
                file.close();
            }
            return bl;
        }
        return true;
    }

    boolean createCLCHome() {
        Path home = this.resolveMcHome();
        try {
            if (!Files.exists(home, new LinkOption[0])) {
                Files.createDirectories(home, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.warn("Failed to create {} directory", (Object)home, (Object)e);
            return false;
        }
        return true;
    }

    boolean createConsoleConfig(String clusterName) {
        try {
            Path binary = this.getCLCExecutablePath();
            if (!Files.exists(binary, new LinkOption[0]) && !this.extractCLCBinary()) {
                return false;
            }
            ClusterModel cluster = this.clusterManager.getCluster(clusterName);
            Path home = this.resolveMcHome();
            Path configDir = this.resolveConfigDirectory(cluster);
            ConsoleManager.removeConsoleConfig((Path)configDir);
            Path configPath = home.resolve(cluster.getId() + ".xml");
            Files.deleteIfExists(configPath);
            ClientConfig clientConfig = this.createClientConfig(cluster);
            String processedConfig = ClientConfigXmlGenerator.generate((ClientConfig)clientConfig);
            Files.writeString(configPath, (CharSequence)processedConfig, new OpenOption[0]);
            boolean isTlsEnabled = clientConfig.getNetworkConfig().getSSLConfig() != null && clientConfig.getNetworkConfig().getSSLConfig().isEnabled();
            int exitValue = this.launchNoninteractiveConsole(clusterName, "config import-java %s %s %s".formatted(cluster.getId(), configPath.toAbsolutePath().toString(), isTlsEnabled ? "ssl.skip-verify=true" : ""));
            this.saveOriginalConfig(configDir, configPath);
            return exitValue == 0;
        }
        catch (IOException e) {
            log.warn("Failed to create CLC config", (Throwable)e);
            return false;
        }
    }

    private Path resolveConfigDirectory(ClusterModel cluster) {
        Path home = this.resolveMcHome();
        return home.resolve("configs").resolve(cluster.getId());
    }

    private Path resolveMcHome() {
        return this.homeDirectoryProvider.get().resolve("clc");
    }

    private void saveOriginalConfig(Path configDir, Path configPath) {
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            Path targetFile = configDir.resolve("source-client-config.xml");
            if (Files.exists(configPath, new LinkOption[0])) {
                String xml = Files.readString(configPath);
                String sanitized = this.clientConfigSanitizer.sanitizeXmlConfig(xml);
                Files.writeString(targetFile, (CharSequence)sanitized, new OpenOption[0]);
                Files.deleteIfExists(configPath);
            }
        }
        catch (IOException e) {
            log.warn("Failed to move original client config to {}", (Object)configDir, (Object)e);
        }
    }

    private ClientConfig createClientConfig(ClusterModel cluster) {
        String clusterName = cluster.getName();
        List currentMemberAddresses = this.memberManager.getDataMembers(clusterName);
        ClientConfig clientConfig = this.clusterManager.getRawClientConfig(clusterName);
        if (!currentMemberAddresses.isEmpty()) {
            clientConfig.getNetworkConfig().setAddresses(currentMemberAddresses);
        }
        return clientConfig;
    }

    boolean isCLCSupportedOS() {
        PlatformUtil.OS os = PlatformUtil.getOS();
        PlatformUtil.Arch arch = PlatformUtil.getArch();
        if (os == PlatformUtil.OS.UNKNOWN || arch == PlatformUtil.Arch.UNKNOWN) {
            return false;
        }
        return SUPPORTED_PLATFORMS.contains(Pair.of((Object)os, (Object)arch));
    }

    boolean isCLCSupportedTLSConfig(String cluster) {
        SSLConfig sslConfig = this.clusterManager.getCluster(cluster).createClientConfig().getNetworkConfig().getSSLConfig();
        if (sslConfig != null && sslConfig.isEnabled()) {
            String ks = sslConfig.getProperty("keyStoreType");
            String ts = sslConfig.getProperty("trustStoreType");
            return !(!StringUtils.isEmpty((CharSequence)ks) && !ks.equals("PKCS12") || !StringUtils.isEmpty((CharSequence)ts) && !ts.equals("PKCS12"));
        }
        return true;
    }

    String getCLCZipName() {
        PlatformUtil.OS os = PlatformUtil.getOS();
        PlatformUtil.Arch arch = PlatformUtil.getArch();
        if (os == PlatformUtil.OS.UNKNOWN || arch == PlatformUtil.Arch.UNKNOWN || !SUPPORTED_PLATFORMS.contains(Pair.of((Object)os, (Object)arch))) {
            return "";
        }
        return String.join((CharSequence)"_", "hazelcast-clc", CLC_VERSION, os.getCode(), arch.getName()).concat(".zip");
    }

    Path getCLCExecutablePath() {
        Path home = this.resolveMcHome();
        return home.resolve(ConsoleManager.getClcExecutableName());
    }

    private void cleanupOldCLCFilesIfExists() {
        Path home = this.resolveMcHome();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(home, "clc*");){
            Files.deleteIfExists(home.resolve("shell.clc"));
            for (Path path : stream) {
                if (!Files.isExecutable(path)) continue;
                Files.delete(path);
            }
        }
        catch (IOException e) {
            log.warn("Failed to delete old CLC files", (Throwable)e);
        }
    }

    private static String getClcExecutableName() {
        return "clc_" + CLC_VERSION + (PlatformUtil.getOS() == PlatformUtil.OS.WINDOWS ? ".exe" : "");
    }

    @ConstructorProperties(value={"consoleRequestProcessor", "homeDirectoryProvider", "clusterManager", "memberManager", "mcConfigurationProperties", "clientConfigSanitizer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ConsoleManager(ConsoleRequestProcessor consoleRequestProcessor, HomeDirectoryProvider homeDirectoryProvider, ClusterManager clusterManager, MemberManager memberManager, MCConfigurationProperties mcConfigurationProperties, ClientConfigSanitizer clientConfigSanitizer) {
        this.consoleRequestProcessor = consoleRequestProcessor;
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.clusterManager = clusterManager;
        this.memberManager = memberManager;
        this.mcConfigurationProperties = mcConfigurationProperties;
        this.clientConfigSanitizer = clientConfigSanitizer;
    }
}

