/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.webmonitor.config.ResponseURLHeaderAddingFilter;
import com.hazelcast.webmonitor.config.UrlPathHelperNonDecoding;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.util.UrlPathHelper;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.templatemode.TemplateMode;

@Configuration
@EnableMethodSecurity(prePostEnabled=false, securedEnabled=true)
public class WebConfig
implements WebMvcConfigurer {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.setOrder(Integer.MIN_VALUE);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ResponseURLHeaderAddingFilter()).addPathPatterns(new String[]{"/**"});
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.clear();
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter(this.jacksonObjectMapper());
        jacksonConverter.setDefaultCharset(StandardCharsets.UTF_8);
        converters.add((HttpMessageConverter<?>)jacksonConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUrlPathHelper((UrlPathHelper)new UrlPathHelperNonDecoding());
    }

    @Bean
    public SpringResourceTemplateResolver xmlTemplateResolver() {
        SpringResourceTemplateResolver xmlTemplateResolver = new SpringResourceTemplateResolver();
        xmlTemplateResolver.setPrefix("classpath:/templates/");
        xmlTemplateResolver.setSuffix(".xml");
        xmlTemplateResolver.setTemplateMode(TemplateMode.XML);
        xmlTemplateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        xmlTemplateResolver.setCheckExistence(true);
        xmlTemplateResolver.setCacheable(false);
        xmlTemplateResolver.setOrder(Integer.valueOf(2));
        return xmlTemplateResolver;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((GenericConverter)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    public ObjectMapper jacksonObjectMapper() {
        return SerializationUtil.OBJECT_MAPPER;
    }
}

