/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.config;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.config.properties.CorsConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.repositories.sql.UserDAO;
import com.hazelcast.webmonitor.security.BearerTokenAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.BearerTokenAuthenticationFilter;
import com.hazelcast.webmonitor.security.CustomAccessDeniedHandler;
import com.hazelcast.webmonitor.security.CustomAuthenticationFailureHandler;
import com.hazelcast.webmonitor.security.CustomAuthenticationSuccessHandler;
import com.hazelcast.webmonitor.security.DevModeAuthenticationFilter;
import com.hazelcast.webmonitor.security.LoginAuthenticationFilter;
import com.hazelcast.webmonitor.security.MethodAwareRequestRejectedHandler;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.service.AuthTokenManager;
import com.hazelcast.webmonitor.service.Clock;
import com.hazelcast.webmonitor.session.SessionControlAuthenticationStrategy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.HttpStatusEntryPoint;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.RequestRejectedHandler;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableWebSecurity
@Profile(value={"!hzcloud"})
public class SecurityConfig {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfig.class);
    private static final String[] ALL_ROLES = new String[]{"ADMIN", "USER", "READONLY_USER", "METRICS_ONLY", "CLOUD_USER"};
    public static final int ONE_YEAR_IN_SECONDS = 31536000;
    private static final String CSP_PENDO_SCRIPT_SRC = "'unsafe-inline' 'unsafe-eval' app.pendo.io pendo-io-static.storage.googleapis.com cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io";
    private static final String CSP_PENDO_STYLE_SRC = "'unsafe-inline' app.pendo.io cdn.pendo.io pendo-static-6720724486979584.storage.googleapis.com";
    private static final String CSP_PENDO_IMG_SRC = "cdn.pendo.io app.pendo.io pendo-static-6720724486979584.storage.googleapis.com data.pendo.io";
    private static final String CSP_PENDO_CONNECT_SRC = "app.pendo.io data.pendo.io pendo-static-6720724486979584.storage.googleapis.com";
    private static final String CSP_PENDO_FRAME_ANCESTORS = "app.pendo.io";
    private static final String CSP_PENDO_FRAME_SRC = "app.pendo.io";
    private static final String CSP_PENDO_CHILD_SRC = "app.pendo.io";
    private static final String CSP_MC_INTERNAL_PATTERNS = "'self' https://*.hazelcast.com https://*.hazelcast.cloud http://localhost:* https://localhost:*";
    private static final Set<String> ALLOWED_METHODS = Set.of(HttpMethod.GET.name(), HttpMethod.POST.name(), HttpMethod.DELETE.name());
    private final MCConfigurationProperties mcProperties;

    private String makeCSPHeaderValue() {
        String frameAncestorsInternal = String.format("%s %s", CSP_MC_INTERNAL_PATTERNS, StringUtils.defaultString((String)this.mcProperties.getInternal().getCloudAddress()));
        return String.join((CharSequence)"; ", String.format("script-src 'self' %s", CSP_PENDO_SCRIPT_SRC), String.format("style-src 'self' %s", CSP_PENDO_STYLE_SRC), String.format("img-src 'self' data: %s", CSP_PENDO_IMG_SRC), String.format("connect-src 'self' %s", CSP_PENDO_CONNECT_SRC), String.format("frame-ancestors %s %s", "app.pendo.io", frameAncestorsInternal), String.format("frame-src %s", "app.pendo.io"), String.format("child-src %s", "app.pendo.io"));
    }

    @Bean
    public WebSecurityCustomizer httpFireWallWebSecurityCustomizer(MethodAwareRequestRejectedHandler methodAwareHandler) {
        return web -> {
            StrictHttpFirewall firewall = new StrictHttpFirewall();
            firewall.setAllowedHttpMethods((Collection)ALLOWED_METHODS);
            firewall.setAllowUrlEncodedSlash(true);
            web.httpFirewall((HttpFirewall)firewall).requestRejectedHandler((RequestRejectedHandler)methodAwareHandler);
        };
    }

    @Bean
    public MethodAwareRequestRejectedHandler methodAwareRequestRejectedHandler() {
        return new MethodAwareRequestRejectedHandler(ALLOWED_METHODS);
    }

    @Bean
    CorsFilter corsFilter(CorsConfigurationProperties props) {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        if (props.isConfigured()) {
            CorsConfiguration corsConfiguration = new CorsConfiguration();
            corsConfiguration.setAllowedOriginPatterns(props.getAllowedOriginPatterns());
            corsConfiguration.setAllowedMethods(props.getAllowedMethods());
            corsConfiguration.setAllowedHeaders(props.getAllowedHeaders());
            corsConfiguration.setExposedHeaders(props.getExposedHeaders());
            corsConfiguration.setAllowCredentials(props.getAllowCredentials());
            corsConfiguration.setAllowPrivateNetwork(props.getAllowPrivateNetwork());
            corsConfiguration.setMaxAge(props.getMaxAge());
            source.registerCorsConfiguration("/**", corsConfiguration);
        }
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @Order(value=3)
    public SecurityFilterChain defaultSecurityFilterChain(HttpSecurity http, CustomAuthenticationSuccessHandler successHandler, AuthTokenManager authTokenManager, AuthenticationManagerImpl authenticationManager, CustomAuthenticationFailureHandler failureHandler, SessionRegistry auditLoggingSessionRegistry, SimpleUrlLogoutSuccessHandler logoutSuccessHandler) {
        CompositeSessionAuthenticationStrategy sessionAuthenticationStrategy = this.getCompositeSessionAuthenticationStrategy(auditLoggingSessionRegistry);
        LoginAuthenticationFilter loginAuthFilter = new LoginAuthenticationFilter(authTokenManager);
        loginAuthFilter.setAuthenticationManager((AuthenticationManager)authenticationManager);
        loginAuthFilter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
        loginAuthFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)failureHandler);
        loginAuthFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)sessionAuthenticationStrategy);
        ConcurrentSessionFilter concurrentSessionFilter = new ConcurrentSessionFilter(auditLoggingSessionRegistry, (SessionInformationExpiredStrategy)new SimpleRedirectSessionInformationExpiredStrategy("/expireSession"));
        return (SecurityFilterChain)http.csrf(csrf -> {
            csrf.ignoringRequestMatchers(new String[]{"/saml/sso**", "/oidc/sso**", "/oauth2/**", "/userinfo", "/metrics"});
            if (this.mcProperties.getInternal().isCloud()) {
                csrf.ignoringRequestMatchers(new String[]{"/login"});
            }
            if (this.mcProperties.isDisableCsrf()) {
                csrf.disable();
            }
        }).cors(Customizer.withDefaults()).addFilter((Filter)new WebAsyncManagerIntegrationFilter()).sessionManagement(Customizer.withDefaults()).securityContext(context -> context.requireExplicitSave(false)).servletApi(Customizer.withDefaults()).logout(customizer -> customizer.logoutSuccessUrl("/login.html").logoutSuccessHandler((LogoutSuccessHandler)logoutSuccessHandler)).exceptionHandling(customizer -> customizer.accessDeniedHandler((AccessDeniedHandler)new CustomAccessDeniedHandler()).authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED))).addFilterAt((Filter)loginAuthFilter, BasicAuthenticationFilter.class).headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable).contentSecurityPolicy(csp -> csp.policyDirectives(this.makeCSPHeaderValue()))).addFilterAt((Filter)concurrentSessionFilter, ConcurrentSessionFilter.class).addFilterBefore((Filter)new DevModeAuthenticationFilter(() -> ((AuthenticationManagerImpl)authenticationManager).isDevModeActive()), AnonymousAuthenticationFilter.class).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.FORWARD})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/login.html", "/session-expired.html", "/error.html", "/api/swagger-ui/config"})).permitAll().requestMatchers(new String[]{"/oauth2/**", "/userinfo"})).permitAll().requestMatchers(new String[]{"/main*", "/api/**"})).hasAnyRole(ALL_ROLES).anyRequest()).permitAll()).build();
    }

    private CompositeSessionAuthenticationStrategy getCompositeSessionAuthenticationStrategy(SessionRegistry auditLoggingSessionRegistry) {
        List<RegisterSessionAuthenticationStrategy> strategies = this.mcProperties.getInternal().isCloud() ? List.of(new SessionControlAuthenticationStrategy(auditLoggingSessionRegistry, this.mcProperties), new RegisterSessionAuthenticationStrategy(auditLoggingSessionRegistry)) : List.of(new SessionControlAuthenticationStrategy(auditLoggingSessionRegistry, this.mcProperties), new SessionFixationProtectionStrategy(), new RegisterSessionAuthenticationStrategy(auditLoggingSessionRegistry));
        return new CompositeSessionAuthenticationStrategy(strategies);
    }

    @Bean
    @Order(value=2)
    public SecurityFilterChain basicAuthSecurityFilterChain(HttpSecurity http) {
        return (SecurityFilterChain)http.headers(headers -> headers.httpStrictTransportSecurity(hsts -> hsts.maxAgeInSeconds(31536000L))).securityMatcher(request -> {
            String authHeader = request.getHeader("Authorization");
            return authHeader != null && authHeader.startsWith("Basic") && !request.getRequestURI().startsWith(request.getContextPath() + "/metrics");
        }).csrf(AbstractHttpConfigurer::disable).cors(Customizer.withDefaults()).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).hasAnyRole(ALL_ROLES)).httpBasic(Customizer.withDefaults()).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).exceptionHandling(ex -> ex.authenticationEntryPoint((AuthenticationEntryPoint)new HttpStatusEntryPoint(HttpStatus.UNAUTHORIZED))).build();
    }

    @Bean
    @Order(value=1)
    @ConditionalOnProperty(value={"hazelcast.mc.rest.enabled"})
    public SecurityFilterChain bearerAuthSecurityFilterChain(HttpSecurity http, AuthTokenManager authTokenManager, AuthenticationManagerImpl authenticationManager, AuditLogService auditLogService) {
        DevModeAuthenticationFilter devModeAuthFilter = new DevModeAuthenticationFilter(() -> ((AuthenticationManagerImpl)authenticationManager).isDevModeActive());
        BearerTokenAuthenticationFailureHandler bearerTokenFailureHandler = new BearerTokenAuthenticationFailureHandler(auditLogService);
        BearerTokenAuthenticationFilter bearerTokenAuthFilter = new BearerTokenAuthenticationFilter("/rest/**", authTokenManager);
        bearerTokenAuthFilter.setAuthenticationManager((AuthenticationManager)authenticationManager);
        bearerTokenAuthFilter.setAuthenticationFailureHandler((AuthenticationFailureHandler)bearerTokenFailureHandler);
        bearerTokenAuthFilter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        return (SecurityFilterChain)http.headers(headers -> headers.httpStrictTransportSecurity(hsts -> hsts.maxAgeInSeconds(31536000L))).securityMatcher(new String[]{"/rest/**"}).csrf(AbstractHttpConfigurer::disable).cors(Customizer.withDefaults()).httpBasic(AbstractHttpConfigurer::disable).addFilterBefore((Filter)devModeAuthFilter, BasicAuthenticationFilter.class).addFilterAt((Filter)bearerTokenAuthFilter, BasicAuthenticationFilter.class).sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.anyRequest()).hasAnyRole(ALL_ROLES)).build();
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public CustomAuthenticationSuccessHandler authenticationSuccessHandler(UserDAO userDAO, Clock clock, ApplicationEventPublisher eventPublisher, AuditLogService auditService) {
        boolean isCloudEnabled = this.mcProperties.getInternal().isCloud();
        boolean isFakeCloud = this.mcProperties.getInternal().isFakeCloud();
        return new CustomAuthenticationSuccessHandler(userDAO, auditService, clock, isCloudEnabled, isFakeCloud, eventPublisher);
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }

    @ConstructorProperties(value={"mcProperties"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SecurityConfig(MCConfigurationProperties mcProperties) {
        this.mcProperties = mcProperties;
    }
}

