/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.cli;

import com.hazelcast.webmonitor.cli.BaseCliTask;
import com.hazelcast.webmonitor.cli.CliException;
import com.hazelcast.webmonitor.repositories.sql.GroupedSettingsDAO;
import com.hazelcast.webmonitor.repositories.sql.SettingsDAO;
import com.hazelcast.webmonitor.security.spi.impl.SecurityConfigurationManager;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.ActiveDirectoryConfig;
import com.hazelcast.webmonitor.security.spi.impl.activedirectory.PersistentActiveDirectoryConfig;
import java.io.PrintWriter;
import java.util.Properties;
import org.jdbi.v3.core.Jdbi;
import org.springframework.core.env.ConfigurableEnvironment;
import picocli.CommandLine;

@CommandLine.Command(description={"Get properties of configured Active Directory security provider."})
public class ListConfiguredActiveDirectoryTask
extends BaseCliTask {
    ListConfiguredActiveDirectoryTask(PrintWriter out, ConfigurableEnvironment environment) {
        super(out, environment);
    }

    public void execute() {
        Jdbi jdbi = this.initJdbi();
        SettingsDAO settingsDAO = new SettingsDAO(jdbi);
        SecurityConfigurationManager securityConfigurationManager = new SecurityConfigurationManager(settingsDAO);
        if (securityConfigurationManager.getCurrentSecurityProviderName() == null) {
            throw new CliException("No Security Provider found!");
        }
        GroupedSettingsDAO groupedSettingsDAO = new GroupedSettingsDAO(jdbi, settingsDAO);
        PersistentActiveDirectoryConfig persistentConfig = new PersistentActiveDirectoryConfig(groupedSettingsDAO);
        String name = securityConfigurationManager.getCurrentSecurityProviderName();
        if (name.equals("Active Directory")) {
            ActiveDirectoryConfig activeDirectoryConfig = persistentConfig.get();
            Properties properties = activeDirectoryConfig.toProperties();
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                this.println(key + "=" + value);
            }
        } else {
            throw new CliException("There is no configured Active Directory security provider.");
        }
    }
}

