/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.auditlog.impl;

import com.hazelcast.webmonitor.auditlog.AuditLogService;
import com.hazelcast.webmonitor.auditlog.Level;
import com.hazelcast.webmonitor.auditlog.impl.AuditableEvent;
import com.hazelcast.webmonitor.auditlog.impl.LoggingAuditLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingAuditLogService
implements AuditLogService {
    public static final String AUDITLOG_CATEGORY = "hazelcast.auditlog";
    private final Logger logger;

    public LoggingAuditLogService() {
        this(LoggerFactory.getLogger((String)AUDITLOG_CATEGORY));
    }

    LoggingAuditLogService(Logger logger) {
        this.logger = logger;
    }

    public void log(AuditableEvent event) {
        Level level = event.getLevel();
        if (!this.isLoggable(level)) {
            return;
        }
        this.log(level, event.toLogMessage(), event.getCause());
    }

    private boolean isLoggable(Level level) {
        return switch (1.$SwitchMap$com$hazelcast$webmonitor$auditlog$Level[level.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.logger.isDebugEnabled();
            case 2 -> this.logger.isInfoEnabled();
            case 3 -> this.logger.isWarnEnabled();
            case 4 -> this.logger.isErrorEnabled();
        };
    }

    private void log(Level level, String message, Throwable cause) {
        switch (1.$SwitchMap$com$hazelcast$webmonitor$auditlog$Level[level.ordinal()]) {
            case 1: {
                this.logger.debug(message, cause);
                break;
            }
            case 2: {
                this.logger.info(message, cause);
                break;
            }
            case 3: {
                this.logger.warn(message, cause);
                break;
            }
            case 4: {
                this.logger.error(message, cause);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Level " + String.valueOf(level));
            }
        }
    }
}

