/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.websocket;

import com.hazelcast.webmonitor.websocket.event.SessionDisconnectedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionSubscribedEvent;
import com.hazelcast.webmonitor.websocket.event.SessionUnsubscribedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.broker.DefaultSubscriptionRegistry;

public class EventPublishingSubscriptionRegistry
extends DefaultSubscriptionRegistry {
    private final ApplicationEventPublisher eventPublisher;

    protected void addSubscriptionInternal(String sessionId, String subscriptionId, String destination, Message<?> message) {
        super.addSubscriptionInternal(sessionId, subscriptionId, destination, message);
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionSubscribedEvent(message));
    }

    protected void removeSubscriptionInternal(String sessionId, String subscriptionId, Message<?> message) {
        super.removeSubscriptionInternal(sessionId, subscriptionId, message);
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionUnsubscribedEvent(message));
    }

    public void unregisterAllSubscriptions(String sessionId) {
        super.unregisterAllSubscriptions(sessionId);
        this.eventPublisher.publishEvent((ApplicationEvent)new SessionDisconnectedEvent(sessionId));
    }

    @ConstructorProperties(value={"eventPublisher"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EventPublishingSubscriptionRegistry(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }
}

