/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.utils;

import com.hazelcast.webmonitor.utils.PlatformUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public final class PlatformUtil {
    private static final Path DOCKER_FILE_PATH = Paths.get("/.dockerenv", new String[0]);

    private PlatformUtil() {
    }

    public static OS getOS() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return OS.UNKNOWN;
        }
        if ((os = os.toLowerCase()).contains("mac")) {
            return OS.MACOS;
        }
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("nix") || os.contains("linux")) {
            return OS.UNIX;
        }
        return OS.UNKNOWN;
    }

    public static Arch getArch() {
        String arch = System.getProperty("os.arch");
        if (arch == null) {
            return Arch.UNKNOWN;
        }
        if ((arch = arch.toLowerCase()).contains("aarch64")) {
            return Arch.ARM64;
        }
        if (arch.contains("amd64") || arch.contains("x86_64")) {
            return Arch.AMD64;
        }
        if (arch.contains("arm")) {
            return Arch.ARM;
        }
        return Arch.UNKNOWN;
    }

    public static boolean isDockerEnv() {
        try {
            DOCKER_FILE_PATH.toRealPath(new LinkOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

