/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.sql;

import com.fasterxml.jackson.databind.JsonNode;
import com.hazelcast.webmonitor.sql.dto.MappingDTO;
import com.hazelcast.webmonitor.sql.dto.SqlMapBrowseDTO;
import com.hazelcast.webmonitor.utils.SerializationUtil;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public final class SqlMapBrowserService {
    private static final Pattern MULTILINE_COMMENT_PATTERN = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern FROM_FUNCTIONS_PATTERN = Pattern.compile("\\(.*?from[^)]*+\\)", 2);
    private static final Pattern TABLE_NAME_PATTERN = Pattern.compile("(?<=from)(\\s\\S+)", 2);
    private static final Pattern KEY_ALIAS_PATTERN = Pattern.compile("(?<=__key as)(\\s\\S+)", 2);
    private static final Set<String> SUPPORTED_CLASSES = Set.of("Integer", "Long", "BigDecimal", "String");

    public Optional<String> parseTableName(String inputQuery) {
        Matcher matcher;
        String sanitizedSql = this.sanitizeSql(inputQuery);
        if (this.acceptableQuery(sanitizedSql) && (matcher = TABLE_NAME_PATTERN.matcher(sanitizedSql.substring(sanitizedSql.toLowerCase().lastIndexOf("from ")))).find()) {
            String tableName = matcher.group(1).trim();
            return Optional.of(tableName);
        }
        return Optional.empty();
    }

    public SqlMapBrowseDTO getMapBrowseInfo(MappingDTO mapping, String sql, List<String> columns) {
        String keyColumnName;
        String keyFormat;
        String keyFormatValue;
        if (!"IMAP".equalsIgnoreCase(mapping.getType())) {
            return SqlMapBrowseDTO.notAllowed();
        }
        JsonNode optionsJson = SerializationUtil.OBJECT_MAPPER.readTree(mapping.getOptions());
        if (optionsJson.get("keyFormat") != null && (keyFormatValue = this.getKeyFormat(optionsJson, keyFormat = optionsJson.get("keyFormat").asText())) != null && columns.contains(keyColumnName = this.getKeyAlias(sql))) {
            return SqlMapBrowseDTO.allowed((String)mapping.getExternalName(), (String)keyColumnName, (String)keyFormatValue);
        }
        return SqlMapBrowseDTO.notAllowed();
    }

    private String getKeyAlias(String sql) {
        Matcher matcher = KEY_ALIAS_PATTERN.matcher(this.sanitizeSql(sql));
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "__key";
    }

    private String getKeyFormat(JsonNode jsonNode, String keyFormat) {
        String keyClass;
        String className;
        if ("java".equals(keyFormat) && SUPPORTED_CLASSES.contains(className = (keyClass = jsonNode.get("keyJavaClass").asText()).substring(keyClass.lastIndexOf(".") + 1))) {
            return className;
        }
        if (keyFormat.toLowerCase().startsWith("varchar")) {
            return "String";
        }
        return switch (keyFormat.toLowerCase()) {
            case "integer", "int" -> "Integer";
            case "bigint" -> "Long";
            case "decimal" -> "BigDecimal";
            default -> null;
        };
    }

    private String sanitizeSql(String inputQuery) {
        String fromFunctionsRemoved = FROM_FUNCTIONS_PATTERN.matcher(inputQuery).replaceAll("");
        return MULTILINE_COMMENT_PATTERN.matcher(fromFunctionsRemoved).replaceAll("").replaceAll("(?m)^\\s*--.*", "").replaceAll("\\s+", " ").replace("\"", "").replace(";", " ");
    }

    private boolean acceptableQuery(String sql) {
        return this.hasFrom(sql) && this.noJoin(sql) && this.noGrouping(sql) && this.noSubSelect(sql) && this.noTableFunction(sql);
    }

    private boolean hasFrom(String sql) {
        return sql.toLowerCase().contains(" from ");
    }

    private boolean noSubSelect(String sql) {
        return StringUtils.countMatches((CharSequence)sql.toLowerCase(), (CharSequence)"select ") == 1;
    }

    private boolean noGrouping(String sql) {
        return !sql.toLowerCase().contains(" group ");
    }

    private boolean noJoin(String sql) {
        return !sql.toLowerCase().contains(" join ");
    }

    private boolean noTableFunction(String sql) {
        return !sql.toLowerCase().contains("table(") && !sql.toLowerCase().contains("table (");
    }
}

