/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.telemetry;

import com.hazelcast.webmonitor.config.properties.BuildInfo;
import com.hazelcast.webmonitor.config.properties.JMXConfigurationProperties;
import com.hazelcast.webmonitor.config.properties.MCConfigurationProperties;
import com.hazelcast.webmonitor.model.telemetry.PhoneHomeData;
import com.hazelcast.webmonitor.security.spi.SecurityProvider;
import com.hazelcast.webmonitor.security.spi.impl.AuthenticationManagerImpl;
import com.hazelcast.webmonitor.security.spi.impl.builtin.DefaultSecurityProvider;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.LicenseManager;
import com.hazelcast.webmonitor.service.telemetry.DataCollector;
import com.hazelcast.webmonitor.service.telemetry.UserLoginEventStore;
import com.hazelcast.webmonitor.utils.DirectorySizeCounter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
public class PhoneHomeDataSupplier
implements Supplier<PhoneHomeData> {
    private static final Path DOCKER_FILE_PATH = Paths.get("/.dockerenv", new String[0]);
    private static final Path KUBERNETES_TOKEN_PATH = Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0]);
    private int counter;
    private final boolean jmxEnabled;
    private final boolean restEnabled;
    private final boolean tlsEnabled;
    private final String tlsMutualAuth;
    private final String serverInfo;
    private final LicenseManager licenseManager;
    private final UserLoginEventStore userLoginEventStore;
    private final AuthenticationManagerImpl authenticationManager;
    private final HomeDirectoryProvider homeDirectoryProvider;
    private final List<DataCollector> additionalCollectors;
    private final boolean isCloudMode;

    public PhoneHomeDataSupplier(JMXConfigurationProperties jmxProperties, MCConfigurationProperties mcProperties, String serverInfo, LicenseManager licenseManager, UserLoginEventStore userLoginEventStore, AuthenticationManagerImpl authenticationManager, HomeDirectoryProvider homeDirectoryProvider, Collection<DataCollector> additionalCollectors) {
        this.jmxEnabled = jmxProperties.isEnabled();
        this.restEnabled = mcProperties.getRest().isEnabled();
        this.tlsEnabled = mcProperties.getTls().isEnabled();
        this.tlsMutualAuth = this.tlsEnabled ? mcProperties.getTls().getMutualAuthentication() : null;
        this.serverInfo = serverInfo;
        this.licenseManager = licenseManager;
        this.userLoginEventStore = userLoginEventStore;
        this.authenticationManager = authenticationManager;
        this.homeDirectoryProvider = homeDirectoryProvider;
        this.additionalCollectors = List.copyOf(additionalCollectors);
        this.isCloudMode = mcProperties.getInternal().isCloud();
    }

    @Override
    public PhoneHomeData get() {
        PhoneHomeData phoneHomeData = new PhoneHomeData();
        phoneHomeData.setCount(++this.counter);
        phoneHomeData.setSecurityProvider(this.getSecurityProviderName());
        phoneHomeData.setJavaVersion(System.getProperty("java.version"));
        phoneHomeData.setOs(System.getProperty("os.name"));
        phoneHomeData.setMcVersion(BuildInfo.getFullVersion());
        phoneHomeData.setJmxEnabled(this.jmxEnabled);
        phoneHomeData.setRestEnabled(this.restEnabled);
        phoneHomeData.setTimeTravelEnabled(true);
        phoneHomeData.setApplicationServer(this.serverInfo);
        phoneHomeData.setStandalone(true);
        phoneHomeData.setViridian(this.isCloudMode);
        phoneHomeData.setTlsEnabled(this.tlsEnabled);
        phoneHomeData.setTlsMutualAuth(this.tlsMutualAuth);
        phoneHomeData.setUsers(this.getNumberOfUsers());
        phoneHomeData.setHomeDirectorySize(DirectorySizeCounter.countDiskSizeOf((Path)this.homeDirectoryProvider.get()));
        phoneHomeData.setUptime(Optional.ofNullable(ManagementFactory.getRuntimeMXBean()).map(RuntimeMXBean::getUptime).orElse(0L).longValue());
        phoneHomeData.setLicenseHash(this.licenseManager.isLicenseConfigured() ? this.licenseManager.getLicense().computeKeyHash() : null);
        phoneHomeData.setUserLoginEvents(this.userLoginEventStore.drain());
        phoneHomeData.setDockerEnv(this.detectDockerEnv());
        phoneHomeData.setVCpuCount(Runtime.getRuntime().availableProcessors());
        this.additionalCollectors.forEach(collector -> collector.collectInto(phoneHomeData));
        return phoneHomeData;
    }

    private String detectDockerEnv() {
        try {
            DOCKER_FILE_PATH.toRealPath(new LinkOption[0]);
            try {
                KUBERNETES_TOKEN_PATH.toRealPath(new LinkOption[0]);
                return "K";
            }
            catch (IOException e) {
                return "D";
            }
        }
        catch (IOException e) {
            return "N";
        }
    }

    private String getSecurityProviderName() {
        return Optional.ofNullable(this.authenticationManager.getCurrentSecurityProvider()).map(SecurityProvider::getName).orElse(null);
    }

    private int getNumberOfUsers() {
        int n;
        SecurityProvider provider = this.authenticationManager.getCurrentSecurityProvider();
        if (provider instanceof DefaultSecurityProvider) {
            DefaultSecurityProvider defaultSecurityProvider = (DefaultSecurityProvider)provider;
            n = defaultSecurityProvider.getUsers().size();
        } else {
            n = 0;
        }
        return n;
    }
}

