/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ReplicatedMapStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ReplicatedMapMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class ReplicatedMapMXBeanImpl
implements ReplicatedMapMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "ReplicatedMaps";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile ReplicatedMapStatsDTO stats;

    public ReplicatedMapMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getReplicatedMapStats(this.cluster, this.name);
    }

    public long getOwnedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getOwnedEntryCount);
    }

    public String getName() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getName, (Object)"");
    }

    public String getCluster() {
        return (String)MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getCluster, (Object)"");
    }

    public long getOwnedEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getOwnedEntryMemoryCost);
    }

    public long getHits() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getHits);
    }

    public long getLastAccessTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getLastAccessTime);
    }

    public long getLastUpdateTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getLastUpdateTime);
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getCreationTime);
    }

    public long getPutOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getPutOperationCount);
    }

    public long getGetOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getGetOperationCount);
    }

    public long getRemoveOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getRemoveOperationCount);
    }

    public long getMaxPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getMaxPutLatency);
    }

    public long getMaxGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getMaxGetLatency);
    }

    public long getMaxRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getMaxRemoveLatency);
    }

    public long getTotalPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getTotalPutLatency);
    }

    public long getTotalGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getTotalGetLatency);
    }

    public long getTotalRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getTotalRemoveLatency);
    }

    public long getOtherOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getOtherOperationCount);
    }

    public long getEvents() {
        return MXBeanHelper.safeGet((Object)this.stats, ReplicatedMapStatsDTO::getEvents);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

