/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.MultiMapStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.MultiMapMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class MultiMapMXBeanImpl
implements MultiMapMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "MultiMaps";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile MultiMapStatsDTO stats;

    public MultiMapMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getMultiMapStats(this.cluster, this.name);
    }

    public long getOwnedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getOwnedEntryCount);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getBackupEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getBackupEntryCount);
    }

    public long getOwnedEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getOwnedEntryMemoryCost);
    }

    public long getBackupEntryMemoryCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getBackupEntryMemoryCost);
    }

    public long getHeapCost() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getHeapCost);
    }

    public long getLockedEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getLockedEntryCount);
    }

    public long getDirtyEntryCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getDirtyEntryCount);
    }

    public long getHits() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getHits);
    }

    public long getLastAccessTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getLastAccessTime);
    }

    public long getLastUpdateTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getLastUpdateTime);
    }

    public long getCreationTime() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getCreationTime);
    }

    public long getPutOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getPutOperationCount);
    }

    public long getGetOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getGetOperationCount);
    }

    public long getRemoveOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getRemoveOperationCount);
    }

    public long getMaxPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getMaxPutLatency);
    }

    public long getMaxGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getMaxGetLatency);
    }

    public long getMaxRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getMaxRemoveLatency);
    }

    public long getTotalPutLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getTotalPutLatency);
    }

    public long getTotalGetLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getTotalGetLatency);
    }

    public long getTotalRemoveLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getTotalRemoveLatency);
    }

    public long getOtherOperationCount() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getOtherOperationCount);
    }

    public long getEvents() {
        return MXBeanHelper.safeGet((Object)this.stats, MultiMapStatsDTO::getEvents);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

