/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.jmx.impl;

import com.hazelcast.webmonitor.controller.dto.clustered.ExecutorStatsDTO;
import com.hazelcast.webmonitor.model.AllState;
import com.hazelcast.webmonitor.service.ClusteredStatsService;
import com.hazelcast.webmonitor.service.jmx.BaseManagementBean;
import com.hazelcast.webmonitor.service.jmx.ExecutorMXBean;
import com.hazelcast.webmonitor.service.jmx.impl.MXBeanHelper;
import javax.management.ObjectName;

public class ExecutorMXBeanImpl
implements ExecutorMXBean,
BaseManagementBean {
    public static final String TYPE_NAME = "Executors";
    private final ClusteredStatsService statsService;
    private final String cluster;
    private final String name;
    private volatile ExecutorStatsDTO stats;

    public ExecutorMXBeanImpl(ClusteredStatsService statsService, String cluster, String name) {
        this.statsService = statsService;
        this.cluster = cluster;
        this.name = name;
    }

    public void updateFrom(AllState state) {
        if (state == null) {
            return;
        }
        this.stats = this.statsService.getExecutorStats(this.cluster, this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCluster() {
        return this.cluster;
    }

    public long getPendingTaskCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getPendingTaskCount);
    }

    public long getStartedTaskCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getStartedTaskCount);
    }

    public long getCompletedTaskCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getCompletedTaskCount);
    }

    public long getCancelledTaskCount() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getCancelledTaskCount);
    }

    public long getTotalExecutionTime() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getTotalExecutionTime);
    }

    public long getTotalStartLatency() {
        return MXBeanHelper.safeGet((Object)this.stats, ExecutorStatsDTO::getTotalStartLatency);
    }

    public ObjectName getObjectName() {
        return BaseManagementBean.getObjectName((String)this.getCluster(), (String)TYPE_NAME, (String)this.getName());
    }
}

