/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.housekeeping;

import com.hazelcast.webmonitor.config.properties.HousekeepingDiskSpaceConfigurationProperties;
import com.hazelcast.webmonitor.notify.Note;
import com.hazelcast.webmonitor.notify.Notifier;
import com.hazelcast.webmonitor.service.HomeDirectoryProvider;
import com.hazelcast.webmonitor.service.healthcheck.PercentageUtils;
import com.hazelcast.webmonitor.service.healthcheck.StorageSizeFormatter;
import com.hazelcast.webmonitor.service.housekeeping.FreeDiskSpaceEvent;
import com.hazelcast.webmonitor.service.housekeeping.NotifyingDiskSpaceChecker;
import com.hazelcast.webmonitor.utils.ExecutorServiceShutdownUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!hzcloud"})
@Component
public class NotifyingDiskSpaceChecker
implements InitializingBean,
AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NotifyingDiskSpaceChecker.class);
    private final HousekeepingDiskSpaceConfigurationProperties properties;
    private final File path;
    private final ApplicationEventPublisher applicationEventPublisher;
    private final Notifier notifier;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "FreeDiskSpaceChecker"));

    @Autowired
    public NotifyingDiskSpaceChecker(HousekeepingDiskSpaceConfigurationProperties properties, HomeDirectoryProvider homeDirectoryProvider, ApplicationEventPublisher applicationEventPublisher, Notifier notifier) {
        this(properties, homeDirectoryProvider.get().toFile(), applicationEventPublisher, notifier);
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.scheduleAtFixedRate(() -> this.check(), 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void close() {
        ExecutorServiceShutdownUtils.shutdownExecutorService((ExecutorService)this.executorService);
    }

    FreeDiskSpaceEvent.Status checkFreeSpace() {
        long freeSpaceInBytes = this.path.getUsableSpace();
        long totalSpaceInBytes = this.path.getTotalSpace();
        long usedSpaceInBytes = totalSpaceInBytes - freeSpaceInBytes;
        double usedSpacePercentage = PercentageUtils.calculatePercentage((long)usedSpaceInBytes, (long)totalSpaceInBytes);
        if (freeSpaceInBytes >= this.properties.getFreeSpaceThreshold().toBytes() && usedSpacePercentage <= (double)this.properties.getUsedSpaceRatioThreshold()) {
            return FreeDiskSpaceEvent.Status.DISK_SPACE_OK;
        }
        long criticalThreshold = this.properties.getFreeSpaceThreshold().toBytes() / 2L;
        if (freeSpaceInBytes >= criticalThreshold) {
            return FreeDiskSpaceEvent.Status.DISK_SPACE_LOW;
        }
        return FreeDiskSpaceEvent.Status.DISK_SPACE_CRITICALLY_LOW;
    }

    void notifyUI(FreeDiskSpaceEvent.Status status) {
        Note note;
        long freeSpaceInBytes = this.path.getUsableSpace();
        long totalSpaceInBytes = this.path.getTotalSpace();
        long usedSpaceInBytes = totalSpaceInBytes - freeSpaceInBytes;
        StorageSizeFormatter storageSizeFormatter = new StorageSizeFormatter(usedSpaceInBytes, totalSpaceInBytes);
        double usedSpacePercentage = PercentageUtils.calculatePercentage((long)usedSpaceInBytes, (long)totalSpaceInBytes);
        String freeSpaceHumanReadable = FileUtils.byteCountToDisplaySize((long)freeSpaceInBytes);
        String totalSpaceHumanReadable = storageSizeFormatter.getConfiguredStorage();
        String usedSpaceHumanReadable = storageSizeFormatter.getUsedStorage();
        String usedSpacePercentageFormatted = String.format("%.2f", usedSpacePercentage);
        log.warn("Management Center free disk space is low. Used: {}% ({} out of {}). Free: {}", new Object[]{usedSpacePercentageFormatted, usedSpaceHumanReadable, totalSpaceHumanReadable, freeSpaceHumanReadable});
        String message = String.format("Used: %s%% (%s out of %s). Free: %s", usedSpacePercentageFormatted, usedSpaceHumanReadable, totalSpaceHumanReadable, freeSpaceHumanReadable);
        switch (1.$SwitchMap$com$hazelcast$webmonitor$service$housekeeping$FreeDiskSpaceEvent$Status[status.ordinal()]) {
            case 1: {
                note = Note.Matter.FREE_DISK_SPACE_IS_LOW.with(message, Duration.ofMinutes(1L));
                break;
            }
            case 2: {
                note = Note.Matter.FREE_DISK_SPACE_IS_CRITICALLY_LOW.with(message, Duration.ofMinutes(1L));
                break;
            }
            default: {
                return;
            }
        }
        this.notifier.signal(note);
    }

    void check() {
        FreeDiskSpaceEvent.Status status = this.checkFreeSpace();
        FreeDiskSpaceEvent event = new FreeDiskSpaceEvent(status);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        if (status != FreeDiskSpaceEvent.Status.DISK_SPACE_OK) {
            this.notifyUI(status);
        }
    }

    @ConstructorProperties(value={"properties", "path", "applicationEventPublisher", "notifier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public NotifyingDiskSpaceChecker(HousekeepingDiskSpaceConfigurationProperties properties, File path, ApplicationEventPublisher applicationEventPublisher, Notifier notifier) {
        this.properties = properties;
        this.path = path;
        this.applicationEventPublisher = applicationEventPublisher;
        this.notifier = notifier;
    }
}

