/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.DeviceConfig;
import com.hazelcast.config.LocalDeviceConfig;
import com.hazelcast.config.MemoryTierConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.AttributeComparisonDispatcher;
import com.hazelcast.webmonitor.service.healthcheck.EqualityAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.healthcheck.TieredStorageAttributeEquivalence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TieredStorageConfigEqualityAnalyzer
extends EqualityAnalyzer {
    TieredStorageConfigEqualityAnalyzer(SourceDataSubscriptionPool poolDelegate) {
        super(poolDelegate);
    }

    private List<Problem> getMemoryTierProblems(Map<String, Map<MemberIdentifier, MemoryTierConfig>> memoryTierConfigs) {
        ArrayList<Problem> memoryTierProblems = new ArrayList<Problem>();
        memoryTierConfigs.forEach((mapName, memberConfigs) -> memoryTierProblems.addAll(AttributeComparisonDispatcher.dispatch((Map)memberConfigs, configs -> new TieredStorageAttributeEquivalence.MemoryTierAttributeEquivalence(configs, "map " + mapName))));
        return memoryTierProblems;
    }

    private List<Problem> getDeviceConfigProblems(Map<String, Map<MemberIdentifier, DeviceConfig>> deviceConfigs) {
        ArrayList<Problem> deviceConfigProblems = new ArrayList<Problem>();
        deviceConfigs.forEach((mapName, memberConfigs) -> {
            List deviceConfigProblemsOfMap = AttributeComparisonDispatcher.dispatch((Map)memberConfigs, configs -> new TieredStorageAttributeEquivalence.DeviceAttributeEquivalence(configs, "map " + mapName));
            if (deviceConfigProblemsOfMap.isEmpty()) {
                Map<MemberIdentifier, LocalDeviceConfig> localDeviceConfigs = memberConfigs.entrySet().stream().filter(entry -> entry.getValue() instanceof LocalDeviceConfig).collect(Collectors.toMap(Map.Entry::getKey, entry -> (LocalDeviceConfig)entry.getValue()));
                List localDeviceProblemsOfMap = AttributeComparisonDispatcher.dispatch(localDeviceConfigs, configs -> new TieredStorageAttributeEquivalence.LocalDeviceAttributeEquivalence(configs, "map " + mapName));
                deviceConfigProblemsOfMap.addAll(localDeviceProblemsOfMap);
            }
            deviceConfigProblems.addAll(deviceConfigProblemsOfMap);
        });
        return deviceConfigProblems;
    }

    protected List<Problem> identifyProblems(Map<MemberIdentifier, Config> effectiveConfigs) {
        HashMap allMemoryTierConfigs = new HashMap();
        HashMap allDeviceConfigs = new HashMap();
        effectiveConfigs.forEach((memberIdentifier, config) -> {
            Map deviceConfigs = config.getDeviceConfigs();
            config.getMapConfigs().forEach((mapName, mapConfig) -> {
                if (!mapConfig.getTieredStoreConfig().isEnabled()) {
                    return;
                }
                MemoryTierConfig memoryTierConfig = mapConfig.getTieredStoreConfig().getMemoryTierConfig();
                allMemoryTierConfigs.computeIfAbsent(mapName, key -> new HashMap()).put(memberIdentifier, memoryTierConfig);
                String deviceName = mapConfig.getTieredStoreConfig().getDiskTierConfig().getDeviceName();
                DeviceConfig deviceConfig = (DeviceConfig)deviceConfigs.get(deviceName);
                allDeviceConfigs.computeIfAbsent(mapName, k -> new HashMap()).put(memberIdentifier, deviceConfig);
            });
        });
        return Stream.concat(this.getMemoryTierProblems(allMemoryTierConfigs).stream(), this.getDeviceConfigProblems(allDeviceConfigs).stream()).collect(Collectors.toList());
    }

    String getCheckId() {
        return AnalyzerCheckId.TIERED_STORAGE_CONFIG_EQUALITY_ANALYZER.getCheckId();
    }

    String describeSelf() {
        return "Checking if Tiered Storage config per Map is the same across members";
    }
}

