/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.AbstractIndexListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.AttributeEquivalence;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MapIndexEquivalence
extends AbstractIndexListEquivalence<MapConfig> {
    private final String mapName;

    MapIndexEquivalence(Map<MemberIdentifier, Config> memberConfigs, String mapName) {
        super(memberConfigs, "map " + mapName);
        this.mapName = mapName;
    }

    AttributeEquivalence<IndexConfig> createElementAttributeEquivalence(AbstractIndexListEquivalence.IndexConfigIdentifier elemId, Map<IndexConfig, Set<MemberIdentifier>> groupsByValues) {
        return new AbstractIndexListEquivalence.IndexAttributeEquivalence(groupsByValues, "map " + this.mapName, elemId);
    }

    MapConfig extractOwner(Config config) {
        return config.getMapConfig(this.mapName);
    }

    Map<AbstractIndexListEquivalence.IndexConfigIdentifier, IndexConfig> extractElements(MapConfig owner) {
        List indexConfigs = owner.getIndexConfigs();
        HashMap<AbstractIndexListEquivalence.IndexConfigIdentifier, IndexConfig> result = new HashMap<AbstractIndexListEquivalence.IndexConfigIdentifier, IndexConfig>(indexConfigs.size());
        for (IndexConfig indexConfig : indexConfigs) {
            result.put(new AbstractIndexListEquivalence.IndexConfigIdentifier(indexConfig), indexConfig);
        }
        return result;
    }
}

