/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.webmonitor.service.healthcheck.AnalyzerCheckId;
import com.hazelcast.webmonitor.service.healthcheck.ClusterWideProblem;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import com.hazelcast.webmonitor.service.healthcheck.SemanticConfigAnalyzer;
import com.hazelcast.webmonitor.service.healthcheck.SourceDataSubscriptionPool;
import com.hazelcast.webmonitor.service.memberconfig.MemberConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

class MapBackupReadEvictionAnalyzer
extends SemanticConfigAnalyzer {
    MapBackupReadEvictionAnalyzer(SourceDataSubscriptionPool pool) {
        super(pool);
    }

    protected List<Problem> doAnalyzeInternal(MemberConfig config, List<String> disabledDataStructures) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        List enabledConfigs = config.toEffectiveConfig().getMapConfigs().values().stream().filter(mapConfig -> !disabledDataStructures.contains(mapConfig.getName())).collect(Collectors.toList());
        for (MapConfig mapConfig2 : enabledConfigs) {
            if (!mapConfig2.isReadBackupData() || !this.isEvictionEnabled(mapConfig2)) continue;
            String mapName = mapConfig2.getName();
            problems.add((Problem)new ClusterWideProblem(String.format("Reads from the backup are enabled in map config %s but are not reflected on the primary member. The entries can, therefore, expire or be evicted if they are read from the backup partition.", mapName), String.format("Turn off backup reads in map config %s", mapName), Problem.ProblemType.FAIL, mapName));
        }
        return problems;
    }

    private boolean isEvictionEnabled(MapConfig mapConfig) {
        return mapConfig.getEvictionConfig() != null && mapConfig.getEvictionConfig().getEvictionPolicy() != EvictionPolicy.NONE || mapConfig.getMaxIdleSeconds() > 0;
    }

    public String describeSelf() {
        return "Checking if backup reads are disabled for maps with TTL-based eviction";
    }

    String getCheckId() {
        return AnalyzerCheckId.MAP_BACKUP_READ_EVICTION_ANALYZER.getCheckId();
    }
}

