/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.webmonitor.service.healthcheck;

import com.hazelcast.config.Config;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.webmonitor.service.MemberIdentifier;
import com.hazelcast.webmonitor.service.healthcheck.ListEquivalence;
import com.hazelcast.webmonitor.service.healthcheck.MemberComparisonProblem;
import com.hazelcast.webmonitor.service.healthcheck.OutlierGroup;
import com.hazelcast.webmonitor.service.healthcheck.Problem;
import java.util.Map;
import java.util.Set;

abstract class AbstractEntryListenerListEquivalence<O>
extends ListEquivalence<O, EntryListenerConfig, String> {
    private final String owningObjectDescr;

    AbstractEntryListenerListEquivalence(Map<MemberIdentifier, Config> memberConfigs, String owningObjectDescr) {
        super(memberConfigs, true);
        this.owningObjectDescr = owningObjectDescr;
    }

    MemberComparisonProblem createProblemForMissingElement(String elemId, Set<MemberIdentifier> membersMissingTheElem, Set<MemberIdentifier> membersContainingTheElem) {
        return MemberComparisonProblem.builder().description(String.format("Entry listener %s is not configured on all members for %s", elemId, this.owningObjectDescr)).advice(String.format("Set the same entry-listeners list for %s in all member configurations", this.owningObjectDescr)).type(Problem.ProblemType.FAIL).addOutlierGroup(OutlierGroup.of((String)("Entry listener " + elemId + " is missing"), membersMissingTheElem)).addOutlierGroup(OutlierGroup.of((String)("Entry listener " + elemId + " is configured"), membersContainingTheElem)).build();
    }
}

